package com.kdgcsoft.jt.xzzf.dubbo.xtba.informationQuery.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * <p>
 * 人员信息VO
 * </p>
 *
 * @author 黄宇
 * @since 2020-02-10
 */
@Data
@TableName("XTBA_J_RYXX")
public class RyXxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 人员信息id
     */
    @TableId(value = "RYXXID")
    private String ryxxid;

    /**
     * 学历代码
     */
    private String xldm;

    /**
     * 人员的性别代码。
     */
    private String xbdm;

    /**
     * 行政区划代码
     */
    private String xzqhdm;

    /**
     * 从业资格证类别代码
     */
    private String cyzgzlbdm;

    /**
     * 从业状态代码
     */
    private String cyztdm;
    /**
     * 从业状态代码 用于接受前台传送的数据
     */
    @TableField(exist = false)
    private String[] cyztdms;
    /**
     * 名族代码
     */
    private String mzdm;

    /**
     * 政治面貌代码
     */
    private String zzmmdm;

    /**
     * 身份证号码
     */
    private String sfzhm;

    /**
     * 姓名
     */
    private String xm;

    /**
     * 从业资格证号
     */
    private String cyzgzh;

    /**
     * 发证日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fzrq;
    /**
     * 发证日期 字符串
     */
    @TableField(exist = false)
    private String fzrqStr;
    /**
     * 有效期止
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date yxqz;
    /**
     * 有效期止 字符串
     */
    @TableField(exist = false)
    private String yxqzStr;
    /**
     * 发证机构
     */
    private String fzjg;

    /**
     * 发证机构统一社会信用代码
     */
    private String fzjgtyshxydm;

    /**
     * 首次发证日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date scfzrq;
    /**
     * 首次发证日期 字符串
     */
    @TableField(exist = false)
    private String scfzrqStr;

    /**
     * 出生日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date csrq;
    /**
     * 出生日期 字符串
     */
    @TableField(exist = false)
    private String csrqStr;

    /**
     * 联系电话
     */
    private String lxdh;

    /**
     * 住址
     */
    private String zz;

    /**
     * 地址邮编
     */
    private String dzyb;

    /**
     * 驾驶证初领日
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date jszclrq;
    /**
     * 驾驶证初领日 字符串
     */
    @TableField(exist = false)
   private String  jszclrqStr;
    /**
     * 准驾车型
     */
    private String zjcx;

    /**
     * 驾驶证号
     */
    private String jszh;
    /**
     * 备注
     */
    private String bz;

    /**
     * 行政区划名称
     */
    @TableField(exist = false)
    private String xzqhmc;

    /**
     * 完整身份证号
     */
    @TableField(exist = false)
    private String completeSfzhm;

    @Override
    public String getId() {
        return ryxxid;
    }

    @Override
    public void setId(String id) {
        this.ryxxid = id;
    }


}
