package com.kdgcsoft.jt.xzzf.dubbo.xtba.informationQuery.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * <p>
 * 人员诚信考核VO
 * </p>
 *
 * @author 黄宇
 * @since 2020-02-10
 */
@Data
@TableName("XTBA_J_RYCXKHXX")
public class RyCxKhXxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId("RYCXKHXXID")
    private String rycxkhxxid;

    /**
     * 信誉等级代码
     */
    private String xydjdm;

    /**
     * 人员信息ID
     */
    private String ryxxid;

    /**
     * 考核年度
     */
    private String khnd;

    /**
     * 考核期起
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date khqq;
    /**
     * 考核期起字符串
     */
    @TableField(exist = false)
    private String khqqStr;
    /**
     * 考核期止
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date khqz;
    /**
     * 考核期止字符串
     */
    @TableField(exist = false)
    private String khqzStr;
    /**
     * 考核计分
     */
    private Long khjf;

    /**
     * 签注日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qzrq;
    /**
     * 签注日期字符串
     */
    @TableField(exist = false)
    private String qzrqStr;

    /**
     * 签注人
     */
    private String qzr;

    /**
     * 签注地点
     */
    private String qzdd;

    /**
     * 签注单位
     */
    private String qzdw;

    /**
     * 签注单位统一社会信用代码
     */
    private String qzdwtyshxydm;

    /**
     * 备注
     */
    private String bz;
    @Override
    public String getId() {
        return rycxkhxxid;
    }

    @Override
    public void setId(String id) {
        this.rycxkhxxid = id;
    }


}
