package com.kdgcsoft.jt.xzzf.dubbo.xtba.informationQuery.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author linian
 * @since 2020-02-17
 */
@Data
@TableName("XTBA_J_CYSRZS")
public class CysrzsVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 船员适任证书ID
     */
    @TableId
    private String cysrzsid;

    /**
     * 适任证书类别代码
     */
    private String srzslbdm;

    /**
     * 证照状态代码
     */
    private String zzztdm;

    /**
     * 船员专业代码
     */
    private String cyzydm;

    /**
     * 适任证书等级代码
     */
    private String srzsdjdm;

    /**
     * 适任证书种类代码
     */
    private String srzszldm;

    /**
     * 船员职务代码
     */
    private String cyzwdm;

    /**
     * 海事机构代码	
     */
    private String hsjgdm;

    /**
     * 适任证书号码
     */
    private String srzshm;

    /**
     * 姓名
     */
    private String xm;

    /**
     * 姓名拼音
     */
    private String xmpy;

    /**
     * 出生日期
     */
    private Date csrq;

    /**
     * 身份证号码
     */
    private String sfzhm;

    /**
     * 国籍
     */
    private String gj;

    /**
     * 联系电话
     */
    private String lxdh;

    /**
     * 联系地址
     */
    private String lxdz;

    /**
     * 证书印刷号
     */
    private String zsysh;

    /**
     * 服务簿号码
     */
    private String fwbhm;

    /**
     * 专业培训号码
     */
    private String zypxhm;

    /**
     * 职务限用
     */
    private String zwxy;

    /**
     * CMDSS职务代码
     */
    private String cmdsszwdm;

    /**
     * 使用级别
     */
    private String syjb;

    /**
     * 受限标志
     */
    private String sxbz;

    /**
     * 适用限制
     */
    private String syxz;

    /**
     * 适用限制英文
     */
    private String syxzyw;

    /**
     * 适任证书签发机构
     */
    private String syzsqfjg;

    /**
     * 签发人
     */
    private String qfr;

    /**
     * 签发日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qfrq;

    /**
     * 最后签注日期
     */
    private Date zhqzrq;

    /**
     * 有效期止
     */
    private Date yxqz;

    /**
     * 创建人
     */
    private String creater;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String updater;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 00未删除01已删除
     */
    private String deleteFlag;

    /**
     * 服务单位联系人
     */
    @TableField(exist = false)
    private String fwdwlxr;

    /**
     * 性别代码
     */
    @TableField(exist = false)
    private String xbdm;

    /**
     * 出生地点
     */
    @TableField(exist = false)
    private String csdd;

    /**
     * 家庭住址
     */
    @TableField(exist = false)
    private String jtzz;

    /**
     * 后台接收前台的证书状态数据
     */
    @TableField(exist = false)
    private String[] zszt;

    /**
     * 签发日期
     */
    @TableField(exist = false)
    private String qfrqStr;

    /**
     * 签发日期
     */
    @TableField(exist = false)
    private String fwdwmc;

    /**
     * 完整身份证号
     */
    @TableField(exist = false)
    private String completeSfzhm;

    @Override
    public String getId() {
        return cysrzsid;
    }

    @Override
    public void setId(String id) {
        this.cysrzsid = id;
    }

}
