package com.kdgcsoft.jt.xzzf.dubbo.xtba.informationQuery.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author linian
 * @since 2020-02-23
 */
@Data
@TableName("XTBA_J_CBXX")
public class CbxxVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 船舶的唯一标识。
     */
    @TableId
    private String cbxxid;

    /**
     * 船体材料代码
     */
    private String ctcldm;

    /**
     * 船籍港代码,对船舶行使登记管理权的海事机构所在行政地区的编码。
     */
    private String cjgdm;

    /**
     * 船舶航行的地区范围编码。
     */
    private String hqdm;

    /**
     * 将船舶按用途划分的船舶种类的编码或代码。
     */
    private String cbzldm;

    /**
     * 船舶推进器种类名称的代码。
     */
    private String cbtjqzldm;

    /**
     * 海事机构代码
     */
    private String hsjgdm;

    /**
     * 船舶主机种类的编码。
     */
    private String cbzjzldm;

    /**
     * 船舶识别号,指用于永久识别船舶的唯一编码。
     */
    private String cbsbh;

    /**
     * 船舶管理部门在办理船舶所有权登记时授予的所有权登记号码。
     */
    private String cbdjh;

    /**
     * 船舶IMO编号,按照国际海事组织A.600决议授予100总吨及以上自航海船的编号。
     */
    private String cbimobh;

    /**
     * MMSI编号
     */
    private String mmsibh;

    /**
     * 船舶呼号,国际海事组织用于对船舶进行呼叫的代号，是主管机关授予每一个通信站点（船舶、飞行器、救生工具等）的一组字母和数字，通常有4~5个字符。中国籍的船舶第一个字母是B，由无线电委员会授予。
     */
    private String cbhh;

    /**
     * 船舶初次登记号,船舶初次办理船舶所有权登记时，有船舶管理部门授予的所有权登记号码。
     */
    private String cbccdjh;

    /**
     * 船舶中文船名,使用中文表述的船舶名称。
     */
    private String cbzwcm;

    /**
     * 船舶英文船名,使用英文或汉语拼音表述的船舶名称。
     */
    private String cbywcm;

    /**
     * 船舶曾用中文船名,最近一个曾使用中文表述的船舶名称。
     */
    private String cbzyzwcm;

    /**
     * 船舶曾用英文船名,最近一个曾使用英文表述的船舶名称。
     */
    private String cbzyywcm;

    /**
     * 国籍
     */
    private String gj;

    /**
     * 船舶原船籍港,最近上一个对该船舶行使登记管理权的海事机构所在行政地区的名称。
     */
    private String cbycjg;

    /**
     * 船舶的价值。
     */
    private Double cbjz;

    /**
     * 原船舶检验机构
     */
    private String ycbjyjg;

    /**
     * 船舶检验机构
     */
    private String cbjyjg;

    /**
     * 审图批准号
     */
    private String stpzh;

    /**
     * 船舶总长,船舶最前端至最后端之间包括外板和两端永久性固定突出物（如顶推装置等）在内的水平距离。
     */
    private Double cbzc;

    /**
     * 船舶型宽,船体型表面之间垂直于中线面的最大水平距离。
     */
    private Double cbxk;

    /**
     * 船舶型深,在船长中点处，沿船舷由平板龙骨上缘量至上层连续甲板横梁上缘的垂直距离；对甲板转角为圆弧形的船舶，则由平板龙骨上缘量至横梁上缘延伸线与肋骨外缘延伸线的交点。
     */
    private Double cbxs;

    /**
     * 船舶总吨,船舶登记证上记载的吨位数，即根据《船舶与海上设施法定检验规则》规定进行丈量确定的船舶总容积计算的吨位数量。
     */
    private Double cbzd;

    /**
     * 船舶净吨,船舶载货的吨位数，即根据《船舶与海上设施法定检验规则》规定进行丈量确定的船舶有效容积计算的吨位数量。
     */
    private Double cbjd;

    /**
     * 参考载重吨,船舶在比重1.025的海水中，相当于所勘划的夏季载重线的排水量与该船空船排水量之差。
     */
    private Double cbzzd;

    /**
     * 船体颜色
     */
    private String ctys;

    /**
     * 检验编号
     */
    private String jybh;

    /**
     * 主机型号
     */
    private String zjxh;

    /**
     * 主机编号
     */
    private String zjbh;

    /**
     * 主机功率
     */
    private Double zjgl;

    /**
     * 主机制造商
     */
    private String zjzzs;

    /**
     * 主机数量
     */
    private Long zjsl;

    /**
     * 安放龙骨日期
     */
    private Date aflgrq;

    /**
     * 船舶建成日期,船舶建造完工的日期。
     */
    private Date cbjcrq;

    /**
     * 船舶建造厂名称,建造船舶的地点。
     */
    private String cbjzcsmc;

    /**
     * 船舶建造厂名称英文,船舶建造地点的英文名称。
     */
    private String cbjzcsmcyw;

    private String zcdd;

    private String zcddyw;

    /**
     * 改建厂家
     */
    private String gjcj;

    /**
     * 船舶改建地点。
     */
    private String gjdd;

    /**
     * 造船地点英文,用英文表示船舶改建的地点。
     */
    private String ywgjdd;

    /**
     * 船舶改建完工日期。
     */
    private Date cbgjrq;

    /**
     * 推进器数目
     */
    private Long tjqsl;

    /**
     * 核定抗风等级
     */
    private String hdkfdj;

    /**
     * 船舶箱位,船上用于承载集装箱的标准箱位数量。
     */
    private Long cbxw;

    /**
     * 船舶客位,船上用于载运旅客的客位数量。
     */
    private Long cbkw;

    /**
     * 船舶车位,船上用于载运车辆的车位数量。
     */
    private Long cbcw;

    /**
     * 船舶所有人名称
     */
    private String cbsyrmc;

    /**
     * 船舶所有人证件号码
     */
    private String cbsyrzjhm;

    /**
     * 船舶所有人法定代表人
     */
    private String cbsyrfddbr;

    /**
     * 船舶所有人法定代表人证件号码
     */
    private String cbsyrfddbrzjhm;

    /**
     * 船舶所有人地址
     */
    private String cbsyrdz;

    /**
     * 船舶经营人名称
     */
    private String cbjyrmc;

    /**
     * 船舶经营人证件号码
     */
    private String cbjyrzjhm;

    /**
     * 船舶经营人法定代表人
     */
    private String cbjyrfddbr;

    /**
     * 船舶经营人法定代表人证件号码
     */
    private String cbjyrfddbrzjhm;

    /**
     * 船舶经营人地址
     */
    private String cbjyrdz;

    /**
     * 内河船舶检验证书
     */
    private String nhcbjyzs;

    /**
     * 证书状态
     */
    private String zszt;

    /**
     * 办理日期
     */
    private Date blrq;

    /**
     * 有效期至
     */
    private Date yxqz;

    /**
     * 创建人
     */
    private String creater;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String updater;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 00未删除01已删除
     */
    private String deleteFlag;
    @Override
    public String getId() {
        return cbxxid;
    }

    @Override
    public void setId(String id) {
        this.cbxxid = id;
    }


}
