package com.kdgcsoft.jt.xzzf.dubbo.xtba.document.service;

import com.kdgcsoft.rdc.document.service.vo.DocumentValueEntity;
import com.kdgcsoft.rdc.document.service.vo.DocumentValueHisEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * 文书排序
 *
 * @author mpp
 */
public interface XtbaDocSortServce {

    /**
     * 获取所有文书
     *
     * @param eventId of type String
     * @return List<DocumentValueEntity>
     */
    List<DocumentValueEntity> getPdfKeys(String eventId);


    /**
     * 获取多文书顺序
     *
     * @param eventId        事件id
     * @param wordTemplateId 文书模板id
     * @return
     */
    List<DocumentValueEntity> getMultiplePdfKeys(String eventId, String wordTemplateId);

    /**
     * 根据版本号获取pdf
     * @param valueId
     * @param versionNumber
     * @return
     */
    List<DocumentValueHisEntity> getPdfKeyByVersionNumber(String valueId, String versionNumber);
}
