package com.kdgcsoft.jt.xzzf.dubbo.xtba.document.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjxxVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.document.entity.WstsjlVO;

import java.util.HashMap;
import java.util.List;

/**
 * 文书推送记录接口
 *
 * @author zd
 * @since 2020-08-25
 */
public interface WstsjlService {

    /**
     * 新增
     *
     * @param wstsjlVO
     * @return
     */
    boolean insert(WstsjlVO wstsjlVO);

    /**
     * 修改
     *
     * @param wstsjlVO
     * @return
     */
    boolean updateById(WstsjlVO wstsjlVO);

    /**
     * 根据ID删除
     *
     * @param id
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取
     *
     * @param id
     * @return
     */
    WstsjlVO getById(String id);


    /**
     * 分页查询
     *
     * @param wstsjlVO
     * @return
     */
    List<WstsjlVO> selectWstsjlPage(WstsjlVO wstsjlVO);

    /**
     * 根据当事人身份证号查询案件信息
     * @param wstsjlVO
     * @return
     */
    List<AjxxVO> searchAjxxForDsr(WstsjlVO wstsjlVO);

    /**
     * 根据valueId查询数据
     * @param valueId
     * @return
     */
    WstsjlVO searchInfoByValueId(String valueId);

    /**
     * 根据当事人身份证号查询未读个数
     * @param wstsjlVO
     * @return
     */
    Integer searchCountForDqz(WstsjlVO wstsjlVO);
}

