package com.kdgcsoft.jt.xzzf.dubbo.xtba.document.service;

import com.kdgcsoft.jt.xzzf.common.component.DocumentTree;

import java.util.List;
import java.util.Map;

/**
 * 对外的文书相关接口
 */
public interface ExternalDocumentService {
    /**
     * 根据事件id，查询案件归档文书
     *
     * @param eventId 事件id
     * @return
     */
    List<DocumentTree> searchGDDocumentList(String eventId);

    /**
     * 根据案件信息id和文书表名，查询对应单份文书信息
     *
     * @param eventId   案件信息id
     * @param tableName 文书表名
     * @return
     */
    Map<String, Object> searchSingleDocumentInfo(String eventId, String tableName);

    /**
     * 根据电子签章id，删除协同办案签章记录信息（用于系统管理签章更换，同步更新协同办案签章信息）
     *
     * @param dzqzId 电子签章id
     * @return
     */
    boolean deleteSignatureInfoForXTBA(String dzqzId);
}
