package com.kdgcsoft.jt.xzzf.dubbo.xtba.document.service;

import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.rdc.document.service.vo.DocumentValueEntity;
import com.kdgcsoft.rdc.document.service.vo.PageRequestParam;

import java.util.List;

/**
 * 校验文书服务
 */
public interface CheckDocumentService {

    /**
     * 获取该案件所有要填写的文书
     *
     * @param eventId
     * @return
     */
    List<ComboboxVo> searchAllSdws(String eventId);

    /**
     * 查询该案件已填写的送达回证
     *
     * @param eventId
     * @return
     */
    List<String> searchYtxSdws(String eventId);

    /**
     * 校验案件有没有填写卷宗、备考表、案卷目录等共公文书
     *
     * @param eventId 事件id
     * @param type    案件类型
     * @return
     */
    String checkGGWSByAjxxId(String eventId, String type);

    /**
     * 校验文书是否多次申请修改
     *
     * @param requestParam
     * @return
     */
    boolean checkIfWssqxg(PageRequestParam requestParam);

    /**
     * 校验是否：非现场超限转立案登记，且"违法在公路上超限行驶"职权的案件
     *
     * @param requestParam
     * @return
     */
    boolean checkIsFxczfaj(PageRequestParam requestParam);

    /**
     * 校验是否是：满足重大案件的条件（停产停业、吊销、个人罚款大于5000，企业罚款大于10000、没收非法所得、减轻处罚）
     * 返回结果：1：重大；2：重大、减轻；3：重大、处罚、不予处罚；4：减轻、处罚、不予处罚
     *
     * @param requestParam
     * @return
     */
    String checkIsZdaj(PageRequestParam requestParam);

    /**
     * 该案件有没有走过"超限告知"流程
     *
     * @param requestParam
     * @return
     */
    boolean checkIsCxgz(PageRequestParam requestParam);

    /**
     * 超限告知是否未超过一个月
     *
     * @param requestParam
     * @return
     */
    boolean checkIsTimeoutForCxgz(PageRequestParam requestParam);

    /**
     * 根据事件id和文书模板id，查询文书信息
     *
     * @param eventId
     * @param wordTemplateId
     * @return
     */
    List<DocumentValueEntity> findDocByEventIdAndWordTemplateId(String eventId, String wordTemplateId);

    /**
     * 根据事件id和模板id查询已填写文书
     *
     * @param eventId
     * @param wordTemplateId
     * @return
     */
    List<DocumentValueEntity> findFilledDocumet(String eventId, String wordTemplateId);

    /**
     * 查询只保存未提交的文书
     *
     * @param eventId
     * @return
     */
    List<String> searchOnlySaveDocument(String eventId);
}
