package com.kdgcsoft.jt.xzzf.dubbo.xtba.document.service;


import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjahVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjxxVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.QzcssjVO;

/**
 * 案号生成
 *
 * @author zd
 */
public interface AnHaoService {
    /**
     * 获取案号
     * @param ajbh
     * @param type
     * @param orgShortName
     * @param ajahVO
     * @return
     */
    public String getAnHao(String ajbh, String type, String orgShortName, AjahVO ajahVO);

    /**
     * 获取事件流水号
     * @param orgId 机构id
     * @return
     */
    public String getShiJianLiuShuiHao(String orgId);

    /**
     * 获取案件顺序号（案号池获取）
     * @param orgId 机构id
     * @param type
     * @return
     */
    public AjahVO getSXHByRedisDistributedLock(String orgId, String type);

    /**
     * 回收案件案号
     * @param ajxxVO
     */
    void recycleAnHao(AjxxVO ajxxVO);

    /**
     * 获取独立强制事件流水号
     * @param orgId
     * @return
     */
    String getShiJianLiuShuiHaoForQz(String orgId);

    /**
     * 回收独立案件案号
     * @param qzcssjVO
     */
    void recycleAnHaoForDlaj(QzcssjVO qzcssjVO);
}
