package com.kdgcsoft.jt.xzzf.dubbo.xtba.document.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/**
 * 文书推送记录实体类
 *
 * @author zd
 * @since 2020-08-25
 */
@Data
@TableName("XTBA_J_WSTSJL")
public class WstsjlVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 文书推送记录ID
     */
    @TableId("WSTSJLID")
    private String wstsjlid;

    /**
     * 事件ID
     */
    private String eventid;

    /**
     * 文书模板ID
     */
    private String wordTemplateId;

    /**
     * 文书ID
     */
    private String valueId;

    /**
     * 是否签字文书（1是 0否）
     */
    private String sfqzws;

    /**
     * 签字状态（01已签字 02未签字）
     */
    private String qzzt;

    /**
     * 1已读0未读
     */
    private String sfyd;

    /**
     * 是否推送当事人（1是 0否）
     */
    private String sftsdsr;


    /**
     * 当事人身份证号
     */
    @TableField(exist = false)
    private String dsrsfzh;

    /**
     * 签字状态文字
     */
    @TableField(exist = false)
    private String qzztText;

    /**
     * 案号
     */
    @TableField(exist = false)
    private String ah;

    /**
     * 案由
     */
    @TableField(exist = false)
    private String ay;

    /**
     * 受案机构名称
     */
    @TableField(exist = false)
    private String sajgmc;

    /**
     * 文书模板名称
     */
    @TableField(exist = false)
    private String wordTemplateName;
    /**
     * 文书表名
     */
    @TableField(exist = false)
    private String tableName;

    /**
     * 违法当事人类别（0：个人，1：法人）跟违法当事人表不一样
     */
    @TableField(exist = false)
    private String wfdsrlbdm;

    /**
     * 驾驶员身份证号
     */
    @TableField(exist = false)
    private String jsysfzh;

    /****
     * 是否是远程异地执法( 0:否 1：是)
     */
    @TableField(exist = false)
    private String isYcyd;

    /****
     * 受案机构
     */
    @TableField(exist = false)
    private String sajgid;


    @Override
    public String getId() {
        return wstsjlid;
    }

    @Override
    public void setId(String id) {
        this.wstsjlid = id;
    }


}
