package com.kdgcsoft.jt.xzzf.dubbo.xtba.document.entity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 统一支付实体类
 */
@Data
public class PayVO implements Serializable {

    /**
     * 缴款时间
     */
    private String checkCode;
    /**
     * 缴款渠道（1 缴款模式，11 柜台缴款，12 自助终端，13 网上缴款，14 pos查缴
     *          2 推送模式 21 pos刷卡 22 网上支付
     *          3 划缴模式 4虚拟转账 9其它）
     */
    private String payMode;
    /**
     * 缴款时间
     */
    private Date cfmTime;
    /**
     * 缴款状态（0：未缴款，1：已缴款）
     */
    private String payStats;
    /**
     * 收款人开户行
     */
    private String recOpBk;
    /**
     * 收款人账号
     */
    private String recAcct;
    /**
     * 收款人名
     */
    private String recName;
    /**
     * 缴款人(单位)
     */
    private String payerName;
    /**
     * 缴款识别码
     */
    private String payCode;
    /**
     * 行政区划
     */
    private String admDivCode;
    /**
     * 原始订单号
     */
    private String billNo;
    /**
     * 接入单位标识（由安徽省统一公共支付平台分配）
     */
    private String sysId;
    /**
     * 原始订单号
     */
    private String billDate;
    /**
     * 原始订单号
     */
    private String billDateStr;
    /**
     * 缴款人
     */
    private String payUser;
    /**
     * 缴款人唯一标识（个人可填写身份证号，单位可填写社会信用代码）
     */
    private String payUserId;
    /**
     * 执收单位编码
     */
    private String chgAgenCode;
    /**
     * 执收单位名称
     */
    private String chgAgenName;
    /**
     * 缴款书金额
     */
    private Double oriAmt;
    /**
     * 滞纳金
     */
    private Double delayAmt;
    /**
     * 缴款金额合计
     */
    private Double amt;
    /**
     * 摘要（项目编码+项目名称+金额，信息以分隔符进行分割，eg：105011401|罚没收入|0.02#）
     */
    private String payInfo;
    /**
     * 备注
     */
    private String remark;
    /**
     * 预留字段
     */
    private String hold1;
    /**
     * 执收单位接入标识
     */
    private String platformId;
    /**
     * 订单查询流水号
     */
    private String queryNo;
    /**
     * 项目数量
     */
    private String projectNo;
    /**
     * 回调接口（缴款完之后的交易通知）
     */
    private String callBackUrl;
}
