package com.kdgcsoft.jt.xzzf.dubbo.xtba.cxtj.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.cxtj.entity.CfajCxtjVo;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.cxtj.entity.CycxQueryVo;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.cxtj.entity.CycxVo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface CfajCxtjService {
    /**
     * 查询处罚案件查询统计 的所有参数和返回值
     * @return
     */
    List<CfajCxtjVo> selectParamAndResult();

    /**
     *  查询 处罚案件查询统计 的查询功能
     * @param paramAndResult 查询参数和查询结果和查询分页参数
     * @return
     */
    Page<HashMap<String,String>> selectResultByParam(String paramAndResult);

    /**
     * 保存查询信息
     * @param cycxXx 常用查询的信息
     * @param userId 当前用户userId
     * @return
     */
    void saveOrUpdateCycx(String cycxXx, String userId);

    /**
     * 查询当前用户的设置常用查询列表
     * @param userId 当前用户userId
     * @return
     */
    List<CycxVo> getCycxList(String userId);

    /**
     * 删除常用查询
     * @param cycxId  常用查询表id
     */
    void delCycx(String cycxId);

    /**
     * 根据id获取 常用查询信息
     * @param cycxId 常用查询表id
     * @return
     */
    CycxQueryVo getXxByCycxId(String cycxId);

    /**
     * 导出
     * @param paramAndResult  查询参数和查询结果
     * @return
     */
    List<Map<String, String>> selectResultByParamExport(String paramAndResult);

    /**
     * 获取处罚依据的信息
     * @param params
     * @return
     */
    List<Map> searchCfyjxx(String params);

    /**
     *
     * @param params
     * @return
     */
    List<Map> searchLayjxx(String params);
}