package com.kdgcsoft.jt.xzzf.dubbo.xtba.cluesManage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.cluesManage.entity.FxczfsjVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.cluesManage.entity.XsczVO;

/**
 * 非现场执法服务类
 *
 * @author zd
 * @since 2020-03-18
 */
public interface FxczfsjService {

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    FxczfsjVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param fxczfsjVO
     * @return
     */
    Page<FxczfsjVO> page(long current, long size, FxczfsjVO fxczfsjVO);

    /**
     * 更改非现场执法状态，改成记录备查状态
     * @param ids 非现场执法主键id（多个逗号拼接）
     * @param fxczfsjVO
     * @return
     */
    boolean jlbc(String ids, FxczfsjVO fxczfsjVO);

    /**
     * 非现场执法处理状态，更新为转入立案登记
     * @param fxczfsjVO
     * @return
     */
    boolean zrladj(FxczfsjVO fxczfsjVO);

    boolean updateById(FxczfsjVO vo);

    /**
     * 根据非现场执法id，查询线索处置信息
     * @param fxczfid
     * @return
     */
    XsczVO searchXsczById(String fxczfid);

    /**
     * 查询出全省电子证据
     * @param current
     * @param size
     * @param fxczfsjVO
     * @return
     */
    Page<FxczfsjVO> fxczfForAdminPage(long current, long size, FxczfsjVO fxczfsjVO);
}

