package com.kdgcsoft.jt.xzzf.dubbo.xtba.cluesManage.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 线索处置实体类
 *
 * @author zd
 * @since 2020-03-31
 */
@Data
@TableName("XTBA_J_XSCZ")
public class XsczVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 线索处置id
     */
    @TableId("XSCZID")
    private String xsczid;

    /**
     * 线索id
     */
    private String xsid;

    /**
     * 线索处置情况
     */
    private String xsclqk;

    /**
     * 处理结果（03经查未核实 04经查情况属实 05经查不属实）
     */
    private String cljg;

    /**
     * 核查人员
     */
    private String hcry1;

    /**
     * 执法证号1
     */
    private String zfzh1;

    /**
     * 执法人员2
     */
    private String zfry2;

    /**
     * 执法证号2
     */
    private String zfzh2;

    /**
     * 核查日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date hcrq;

    /**
     * 线索类别（01投诉举报 02治超事件后续处理 03非现场执法）
     */
    private String xslb;

    /**                 表外字段                 **/
    /**
     * 附件id 数组
     */
    @TableField(exist = false)
    private String[] fjid;
    /**
     * 核查日期字符串
     */
    @TableField(exist = false)
    private String hcrqStr;
    /**
     * 附件类型
     */
    @TableField(exist = false)
    private String fjlx;

    /**
     * 附件信息json数据
     */
    @TableField(exist = false)
    private String fjJson;

    /**
     * flag用于判断治超事件后续处理是人员、车辆、还是企业
     */
    @TableField(exist = false)
    private String flag;

    /**
     * 非现场类型
     */
    @TableField(exist = false)
    private String fxclx;

    /**
     * 保存路径
     */
    @TableField(exist = false)
    private List bcljArr;
    /**
     * 材料名称
     */
    @TableField(exist = false)
    private List clmcArr;
    /**
     * 附件id
     */
    @TableField(exist = false)
    private List fjidArr;

    @Override
    public String getId() {
        return xsczid;
    }

    @Override
    public void setId(String id) {
        this.xsczid = id;
    }

}
