package com.kdgcsoft.jt.xzzf.dubbo.xtba.cluesManage.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 非现场执法实体类
 *
 * @author zd
 * @since 2020-03-18
 */
@Data
@TableName("XTBA_J_FXCZFSJ")
public class FxczfsjVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 非现场执法id
     */
    @TableId
    private String fxczfid;

    /**
     * 线索处理状态
     */
    private String xsclztdm;

    /**
     * 制作单位
     */
    private String zzdw;

    /**
     * 制作人
     */
    private String zzr;

    /**
     * 制作日期
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date zzrq;

    /**
     * 预检时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date yjrq;

    /**
     * 车牌号码
     */
    private String cphm;

    /**
     * 轴数
     */
    private Long zs;

    /**
     * 限重
     */
    private Double xz;

    /**
     * 预检重量
     */
    private Double yjzl;

    /**
     * 超限重量
     */
    private Double cxzl;

    /**
     * 超限率
     */
    private Double cxl;

    /**
     * 预检车速
     */
    private Double yjcs;

    /**
     * 是否上报
     */
    private String sfsb;

    /**
     * 备注
     */
    private String bz;

    /**
     * 检测站点编码
     */
    private String jczbm;

    /**
     * 检测站名称
     */
    private String jczmc;

    /*********************查询字段************************/
    /**
     * 制作日期起
     */
    @TableField(exist = false)
    private String zzrqStart;

    /**
     * 制作日期止
     */
    @TableField(exist = false)
    private String zzrqEnd;

    /**
     * 预检日期起
     */
    @TableField(exist = false)
    private String yjrqStart;

    /**
     * 预检日期止
     */
    @TableField(exist = false)
    private String yjrqEnd;

    /**
     * 组织机构
     */
    @TableField(exist = false)
    private String orgId;

    /**
     * 检测站点编码
     */
    @TableField(exist = false)
    private List<String> jczbms;

    /**************************证据信息回显字段***************************/

    /**
     * 保存路径
     */
    @TableField(exist = false)
    private List bcljArr;
    /**
     * 材料名称
     */
    @TableField(exist = false)
    private List clmcArr;
    /**
     * 附件id
     */
    @TableField(exist = false)
    private List fjidArr;

    /**
     * 案号
     */
    @TableField(exist = false)
    private String ah;

    /**
     * 流水号
     */
    @TableField(exist = false)
    private String sjlsh;

    /**
     *执法门类代码
     */
    @TableField(exist = false)
    private String zfmlCode;

    /**
     *职权项目id
     */
    @TableField(exist = false)
    private String zqxmid2;

    /**
     *职权项目版本号
     */
    @TableField(exist = false)
    private String zqxmbbh;

    /**
     *职权项目名称
     */
    @TableField(exist = false)
    private String zqxmmc;

    /**
     *案件信息id
     */
    private String ajxxid;

    /**
     *gzlid
     */
    @TableField(exist = false)
    private String gzlid;

    /**
     *hjid
     */
    @TableField(exist = false)
    private String hjid;

    /**
     *hddyid
     */
    @TableField(exist = false)
    private String hddyid;

    /**
     *hjmc
     */
    @TableField(exist = false)
    private String hjmc;

    /**
     *mainProcessInstId
     */
    @TableField(exist = false)
    private String mainProcessInstId;

    /**
     *ahOrlsh
     */
    @TableField(exist = false)
    private String ahOrlsh;

    /**
     *所属区域
     */
    @TableField(exist = false)
    private String ssqy;

    /**
     *ahOrlsh
     */
    @TableField(exist = false)
    private String bj;

    /**
     *  非现场类型
     */
    private String fxclx;
    /**
     *  非现场类型编码
     */
    @TableField(exist = false)
    private String fxclxCode;
    /**
     *  查询范围
     */
    @TableField(exist = false)
    private String cxfw;
    /**
     *  案件状态代码
     */
    @TableField(exist = false)
    private String ajztdm;


    @Override
    public String getId() {
        return fxczfid;
    }

    @Override
    public void setId(String id) {
        this.fxczfid = id;
    }


}
