package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.ZfjlyclVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.ZfjlyzjjlVO;

import java.util.List;

/**
 * 执法记录仪证据记录接口
 *
 * @author zd
 * @since 2020-03-24
 */
public interface ZfjlyzjjlService {

    /**
     * 执法记录仪证据记录分页查询
     *
     * @param current     当前页
     * @param size        每页显示条数
     * @param zfjlyzjjlVO
     * @return
     */
    Page<ZfjlyzjjlVO> page(long current, long size, ZfjlyzjjlVO zfjlyzjjlVO);

    /**
     * 根据案件信息id，查询执法音视频
     *
     * @param ajxxId 案件信息id
     * @return
     */
    List<ZfjlyzjjlVO> searchListByAjxxId(String ajxxId);

    /**
     * 案件绑定执法音视频
     *
     * @param ajxxid 案件信息id
     * @param clids  音视频材料id
     * @return
     */
    boolean bindZfyspForAjxx(String ajxxid, String clids);

    /**
     * 根据关联id，删除案件绑定的执法音视频（支持批量删除，多个逗号拼接）
     *
     * @param zfjlyclAjxxGlid 案件、执法音视频材料关联id
     * @return
     */
    boolean deleteZfyspByGlid(String zfjlyclAjxxGlid);
}

