package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjxxVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.Ajyjxx;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.laws.entity.FxqdVO;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 预警清单
 *
 * @author mpp
 */
public interface YjService {


    /**
     * 根据算法编码获取预警清单
     *
     * @param code
     * @return
     */
    public List<FxqdVO> getByCode(String code);

    /**
     * 预警信息查询
     *
     * @param page
     * @param map
     * @return
     */
    public Page page(Page<Ajyjxx> page, Map map);

    /**
     * 风险清单combox
     *
     * @return
     */
    public List<ComboboxVo> listForCombox();

    /**
     * 获取所有案件信息
     * @return
     */
    List<AjxxVO> getAjxxList();

    /**
     * 删除预警信息
     */
    void deleteYjxx();

    /**
     * 保存预警信息
     */
    void insertYjxx(Ajyjxx ajyjxx);

    /**
     * 根据案件信息id，查询该案件超限告知提交时间
     * @param ajxxid
     * @return
     */
    Date searchCxgzByAjxxId(String ajxxid);

    /**
     * 根据组织机构信息统计风险预警数量--首页
     * @param map
     * @return
     */
    public Integer queryCount(Map map);

    List<AjxxVO> getList();
}
