package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.WgxxVO;

import java.util.List;

/**
 * 违规信息服务层
 *
 * @author zd
 * @since 2020-08-04
 */
public interface WgxxService {

    /**
     * 新增信息
     *
     * @param wgxxVO
     * @return
     */
    boolean insert(WgxxVO wgxxVO);

    /**
     * 修改信息
     *
     * @param wgxxVO
     * @return
     */
    boolean updateById(WgxxVO wgxxVO);


    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    WgxxVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param wgxxVO
     * @return
     */
    Page<WgxxVO> page(long current, long size, WgxxVO wgxxVO);

    /**
     * 根据线索编号，批量查询线索案件状态
     * @param xsbh 线索编号
     * @return
     */
    List<WgxxVO> searchChaXunInfo(String xsbh);

    /**
     * 根据线索编号更新
     * @param xsbh 线索编号
     * @return
     */
    boolean updateByXsbh(WgxxVO xsbh);

    /**
     * 北斗不在线页面分页查询
     * @param current
     * @param size
     * @param wgxxVO
     * @return
     */
    Page<WgxxVO> bdbzxPage(long current, long size, WgxxVO wgxxVO);
}

