package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.WfdsrVO;


import java.util.List;

/**
 * 违法当事人接口
 * @author zd
 * @since 2020-01-17
 */
public interface WfdsrService {

    /**
     * 新增信息
     *
     * @param wfdsrVO
     * @return
     */
    boolean insert(WfdsrVO wfdsrVO);

    /**
     * 修改信息
     *
     * @param wfdsrVO
     * @return
     */
    boolean updateById(WfdsrVO wfdsrVO);

    /**
     * 根据ID删除信息
     *
     * @param id　ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    WfdsrVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param wfdsrVO
     * @return
     */
    Page<WfdsrVO> page(long current, long size, WfdsrVO wfdsrVO);

    /**
     * 查询当事人信息
     * @param wfdsrVO
     * @return
     */
    WfdsrVO searchDSRInfo(WfdsrVO wfdsrVO);

    /**
     * 根据统一社会信用代码查询
     * @param tyshxydm 统一社会信用代码
     * @return
     */
    List<WfdsrVO> searchInfoByTyshxydm(String tyshxydm);
}

