package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.WfclVO;


import java.util.List;

/**
 * 违法车辆接口
 * @author zd
 * @since 2020-01-17
 */
public interface WfclService {

    /**
     * 新增信息
     *
     * @param wfclVO
     * @return
     */
    boolean insert(WfclVO wfclVO);

    /**
     * 修改信息
     *
     * @param wfclVO
     * @return
     */
    boolean updateById(WfclVO wfclVO);

    /**
     * 根据ID删除信息
     *
     * @param id　ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    WfclVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param wfclVO
     * @return
     */
    Page<WfclVO> page(long current, long size, WfclVO wfclVO);

    /**
     * 查询违法车辆信息
     * @param wfclVO
     * @return
     */
    List<WfclVO> searchCLInfo(WfclVO wfclVO);

}

