package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.WfcbVO;


import java.util.List;


/**
 * <p>
 *  违法船舶服务类
 * </p>
 *
 * @author zd
 * @since 2020-01-17
 */
public interface WfcbService {

    /**
     * 新增信息
     *
     * @param wfcbVO
     * @return
     */
    boolean insert(WfcbVO wfcbVO);

    /**
     * 修改信息
     *
     * @param wfcbVO
     * @return
     */
    boolean updateById(WfcbVO wfcbVO);

    /**
     * 根据ID删除信息
     *
     * @param id　ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    WfcbVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param wfcbVO
     * @return
     */
    Page<WfcbVO> page(long current, long size, WfcbVO wfcbVO);

    /**
     * 查询船舶信息
     * @param wfcbVO
     * @return
     */
    List<WfcbVO> searchCBInfo(WfcbVO wfcbVO);
}

