package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjzjclVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.TsJbVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.TsstYwclCaseBean;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.common.entity.FjbVO;
import java.text.ParseException;
import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author 黄宇
 * @since 2020-02-24
 */
public interface TsJbService {

    /**
     * 新增信息
     *
     * @param xtbaJTsjb
     * @return
     */
    boolean insert(TsJbVO xtbaJTsjb);

    /**
     * 修改信息
     *
     * @param xtbaJTsjb
     * @return
     */
    boolean updateById(TsJbVO xtbaJTsjb);

    /**
     * 根据ID删除信息
     *
     * @param id　ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    TsJbVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param xtbaJTsjb
     * @return
     */
    Page<TsJbVO> page(long current, long size, TsJbVO xtbaJTsjb);

    /**
     * 新增附件信息
     * @param fjbVO
     * @return
     */
    Boolean insertToFjB(FjbVO fjbVO);

    /**
     * 投诉举报页面上的删除操作
     * @param vo
     * @return
     */
    Boolean deleteTsJb(TsJbVO vo);

    /**
     * 更新投诉举报状态
     * @param vo
     * @return
     */
    Boolean updateTsJb(TsJbVO vo);

    /**
     * 更新附件表
     * @param tsJbVO
     * @return
     */
    Boolean updateByFjId(TsJbVO tsJbVO);

    /**
     * 提交修改之后的数据
     * @param tsJbVO
     * @return
     */
    Boolean updateTsjbByXG(TsJbVO tsJbVO);

    Boolean deleteFjbXx(FjbVO fjbVO);


    /***
     * 投诉举报页面转入立案登记页面的操作
     * @param tsJbVO
     * @param ajzjclVO
     */
    void addZJCl(TsJbVO tsJbVO, AjzjclVO ajzjclVO);

    /**
     *通过远程接口插入/更新数据
     * @param list
     */
    void insertByUrl(List<TsstYwclCaseBean> list, TsJbVO tsJbVO) throws ParseException;

    /**
     * 向XTBA_J_TSJB数据库插入立案登记人姓名和立案时间
     * @param tsJbVO
     */
    void ladj(TsJbVO tsJbVO);
}

