package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjxxVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.FjjnmxVo;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.YhsjmxVo;

import java.util.List;

/**
 * <p>
 * 执法类型：用于案件行业统计
通过案件信息表关联职权项目执法依据表来获取执法依据数据
保留职权Id和版本号便于职权统计，查询职权对应的自由裁量权

数据来源：01 pc系统录入
02  移动执法APP
03  线索转入

强制标识
　　１　是　　０否
冗余立案依据、处罚依据等案件数据与执法公示系统对接，尽量避免与文书表过多关联 服务类
 * </p>
 *
 * @author linian
 * @since 2020-01-16
 */
public interface SaxxdzService {

    /**
     * 涉案金额对账缴纳和未缴纳总金额
     * @param AjxxVO 案件信息VO
     * @return 涉案金额对账页面案件信息
     */
    AjxxVO searchFkjeTotal(AjxxVO AjxxVO);

    /**
     * 涉案金额对账页面分页查询
     * @param current 当前页
     * @param size 每页显示条数
     * @param AjxxVO 案件信息VO
     * @return 涉案金额对账页面案件信息
     */
    Page<AjxxVO> searchAjxxInfoPage(long current, long size, AjxxVO AjxxVO);

    /**
     * 对账明细
     * @param ajxxid 案件信息ID
     * @return 对账明细信息
     */
    AjxxVO findDzmxInfo(String ajxxid);

    /**
     * 应缴金额明细
     * @param ajxxid 案件信息ID
     * @return 应缴金额明细
     */
    List<FjjnmxVo> yjjemxInfo(String ajxxid);

    /**
     * 实际缴纳明细
     * @param ajxxid 案件信息ID
     * @return 实际缴纳明细
     */
    List<YhsjmxVo> sjjnmxInfo(String ajxxid);

    /**
     * 导出涉案金额信息
     * @param ajxxVo
     * @return
     */
    List<AjxxVO> exportSajexx(AjxxVO ajxxVo);
}

