package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjxxVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.QzcssjVO;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 强制措施service
 *
 * @author zd
 * @since 2020-04-28
 */
public interface QzcssjService {

    /**
     * 修改信息
     *
     * @param qzcssjVO
     * @return
     */
    boolean updateById(QzcssjVO qzcssjVO);

    /**
     * 根据ID删除信息
     *
     * @param id 　ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    QzcssjVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param map
     * @return
     */
    Page<QzcssjVO> selectQzcsPage(long current, long size, Map<String, Object> map);

    /**
     * 添加处罚强制措施事件
     *
     * @param vo
     * @param ajxxVO
     * @return
     */
    boolean addQzcssj(QzcssjVO vo, AjxxVO ajxxVO);

    /**
     * 根据案件信息id，查询处罚强措
     *
     * @param ajxxId 案件信息id
     * @return
     */
    List<QzcssjVO> selectXzqzByAjxxId(String ajxxId, String ajlbdm);

    /**
     * 行政强制案件数量统计--分析研判
     *
     * @param ajxxVO
     * @return
     */
    Map<String, Integer> xzqzajslCount(AjxxVO ajxxVO);

    /**
     * 强制案件分页查询
     *
     * @param page
     * @param qzcssjVO
     * @return
     */
    Page<QzcssjVO> qzajcxPage(Page<Object> page, QzcssjVO qzcssjVO);

    List<QzcssjVO> qzajcxExport(QzcssjVO qzcssjVO);

    /**
     * 根据强制案件信息id
     *
     * @param qzajxxid
     * @return
     */
    QzcssjVO searchQzajByQzajxxId(String qzajxxid);

    /**
     * 处罚强措待办数量统计--首页
     *
     * @param map
     * @return
     */
    Integer queryDaiBanCount(Map<String, Object> map);

    /**
     * 根据OrgId统计行政强制办件数量--首页Echarts，统计案件状态代码为02，03，04的数据
     *
     * @param qzcssjVO 实体类
     * @return
     */
    Integer getXzqzCountByOrgId(QzcssjVO qzcssjVO);

    /**
     * 根据主键id查询信息
     *
     * @param ajxxid 主键id
     * @return
     */
    QzcssjVO searchInfoById(String ajxxid);

    /**
     * 根据强制案件信息id，查询处罚强措
     * @param eventId   强制案件信息id
     * @param cfqzcs    案件类别代码
     * @return
     */
    List<QzcssjVO> selectXzqzByQzcssjid(String eventId, String cfqzcs);
}

