package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.ClcxxxVO;


/**
 * <p>
 *  车辆超限信息
 * </p>
 *
 * @author zd
 * @since 2020-01-17
 */
public interface ClcxxxService {

    /**
     * 新增信息
     *
     * @param clcxxxVO
     * @return
     */
    boolean insert(ClcxxxVO clcxxxVO);

    /**
     * 修改信息
     *
     * @param clcxxxVO
     * @return
     */
    boolean updateById(ClcxxxVO clcxxxVO);

    /**
     * 根据ID删除信息
     *
     * @param id　ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    ClcxxxVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param clcxxxVO
     * @return
     */
    Page<ClcxxxVO> page(long current, long size, ClcxxxVO clcxxxVO);

    /**
     * 根据事件id查询车辆超限信息
     * @param ajxxId 案件信息id
     * @return
     */
    ClcxxxVO searchCLCXInfoByAjxxId(String ajxxId);
}

