package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjxxVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjzxVO;
import java.util.List;
/**
 * 案件注销接口
 * @author zk
 */
public interface AjzxService {

    /**
     * 初始化/查询案件注销界面
     * @param current
     * @param size
     * @param ajzxVO
     * @return
     */
    Page<AjzxVO> page(long current, long size, AjzxVO ajzxVO);

    /**
     * 执行注销
     * @param ajzxVO
     */
    boolean zxzx(AjzxVO ajzxVO, List<AjzxVO> list);

    /**
     * 撤回注销
     * @param ajzxVO
     * @return
     */
    boolean chzx(AjzxVO ajzxVO, List<AjzxVO> list);

    /**
     * 案件注销添加
     * @param ajzxVO
     * @return
     */
    boolean insert(AjzxVO ajzxVO);

    /**
     * 根据案件信息id，查询案件注销信息
     * @param ajxxId 案件信息id
     * @return
     */
    AjzxVO searchAjzxByAjxxId(String ajxxId);

    /**
     * 获取案件详细信息
     */
    List<AjxxVO> selectAjxxById(String ajxxid);

    /**
     * 据案件信息id，查询案件待注销案件
     * @param ajxxId
     * @return
     */
    AjzxVO searchDzxByAjxxId(String ajxxId);


}

