package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjzjclVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.common.entity.FjbVO;

public interface AjzjclService {

    /**
     * 自定义分页查询
     * @param current
     * @param size
     * @param ajzjclVO
     * @return
     */
    Page<AjzjclVO> searchEviPage(long current, long size, AjzjclVO ajzjclVO);

    /**
     * 新增
     * @param ajzjclVO
     * @return
     */
    boolean insert(AjzjclVO ajzjclVO);

    /**
     * 修改
     * @param ajzjclVO
     * @return
     */
    boolean updateById(AjzjclVO ajzjclVO);

    /**
     * 根据id获取证据详情
     * @param ajzjclid
     * @return
     */
    AjzjclVO getZjxqById(String ajzjclid);

    /**
     * 案件证据材料上传
     * @param vo
     * @return
     */
    boolean zjclUpload(AjzjclVO vo);

    /**
     * 根据案件证据材料id，获取证据材料信息
     * @param ajzjclid 案件证据材料id
     * @return
     */
    AjzjclVO searchInfoByAjzjclId(String ajzjclid);

    /**
     * 向对应的附件表中插入ajzjclid
     * @param ajzjclVO
     * @return
     */
    boolean updateFj(AjzjclVO ajzjclVO);

    /**
     * 根据fjid删除附件表对应的数据
     * @param fjbVO
     */
    void deleteFjbById(FjbVO fjbVO);

    /**
     *上传附件
     * @param ajzjclid
     * @param fjJson
     * @return
     */
    boolean uploadAttachments(String ajzjclid, String fjJson);

    /**
     * 根据案件信息id，查询案件证据材料列表
     * @param current
     * @param size
     * @param ajzjclVO
     * @return
     */
    Page<AjzjclVO> searchAjzjByAjxxId(long current, long size, AjzjclVO ajzjclVO);

    /**
     * 案件证据材料删除（根据案件证据材料ID，多个逗号拼接）
     * @param ids
     * @param curUser
     * @return
     */
    boolean deleteFjByIds(String ids, SysUser curUser);
}

