package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysOrg;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.*;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.common.entity.FjbVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.xtgl.entity.Ajysxx;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.AjInfoVO;


import java.util.HashMap;
import java.util.List;

/**
 * 案件信息接口
 *
 * @author zd
 * @since 2020-01-16
 */
public interface AjxxService {

    /**
     * 批量删除
     *
     * @param ajxxVO
     * @return
     */
    boolean deleteByIds(AjxxVO ajxxVO);

    /**
     * 根据案件信息id查询案件
     *
     * @param id
     * @return
     */
    AjxxVO searchEventById(String id);

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param ajxxVO
     * @return
     */
    Page<AjxxVO> page(long current, long size, AjxxVO ajxxVO);

    /**
     * 归档分页查询
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param ajxxVO
     * @return
     */
    Page<AjxxVO> guiDangPage(long current, long size, AjxxVO ajxxVO);

    /**
     * 新增案件信息
     *
     * @param map
     * @return
     */
    boolean insertAjxx(HashMap<String, Object> map);

    /**
     * 修改案件信息
     *
     * @param map
     * @return
     */
    boolean updateAjxx(HashMap<String, Object> map);

    /**
     * 修改
     *
     * @param ajxxVO
     * @return
     */
    boolean updateById(AjxxVO ajxxVO);

    /**
     * 查询行政处罚信息
     *
     * @param current
     * @param size
     * @param ajxxVO
     * @return
     */
    Page<AjxxVO> searchXzcfInfo(long current, long size, AjxxVO ajxxVO);

    /**
     * 根据案件证据材料id，获取附件信息
     *
     * @param ajzjclid 案件证据材料id
     * @return
     */
    List<FjbVO> searchFileByAjzjclId(String ajzjclid);

    /**
     * 查询历史违法记录总数
     *
     * @param ajxxVO
     * @return
     */
    Integer searchXzcfCount(AjxxVO ajxxVO);

    /**
     * 根据案件信息id，查询案件信息
     *
     * @param ajxxid 案件信息id
     * @return
     */
    AjxxVO searchAjxxByAjxxId(String ajxxid);

    /**
     * 注销未审批案件
     *
     * @param ajxxVO
     * @param ajzxVO
     * @return
     */
    boolean zxAjByAjxxId(AjxxVO ajxxVO, AjzxVO ajzxVO);

    /**
     * 执法人员查询处罚信息
     *
     * @param ajInfoVO
     * @param page
     * @return
     */
    Page<AjInfoVO> queryCfInfo(AjInfoVO ajInfoVO, long current, long size);

    /**
     * 案件移送
     *
     * @param ajysxx
     * @param list
     */
    void ajys(Ajysxx ajysxx, List<AjxxVO> list);

    /**
     * 案件移送判断
     *
     * @param list
     * @return
     */
    boolean judgeExist(List<AjxxVO> list);


    /**
     * 根据案件信息id查询word所需数据
     *
     * @param ajxxId
     * @return
     */
    AjgsVo searchAjxxForExportWord(String ajxxId);

    /**
     * 搜索强制案件
     *
     * @param qzcssjid
     * @return
     */
    QzcssjVO searchQzEventById(String qzcssjid);

    /**
     * 执法人员查询强制案件信息
     *
     * @param ajInfoVO
     * @param current
     * @param size
     * @return
     */
    Page<AjInfoVO> queryCfQzInfo(AjInfoVO ajInfoVO, long current, long size);

    /**
     * 执法人员查询强制案件数量
     *
     * @param ajInfoVO
     * @return
     */
    Integer queryQzAjSl(AjInfoVO ajInfoVO);

    /**
     * 执法人员查询处罚案件数量
     *
     * @param ajInfoVO
     * @return
     */
    AjInfoVO queryCfAjSl(AjInfoVO ajInfoVO);

    /**
     * 根据案件信息id查询该案件流程信息
     *
     * @param ajxxid
     * @return
     */
    AjxxVO searchEventActInfoByAjxxId(String ajxxid);

    /**
     * 根据执法人员id，查询执法人员对应的用户信息
     *
     * @param zfryId 执法人员id
     * @return
     */
    SysUser searchUserInfoByZfryId(String zfryId);

    /**
     * 根据机构名称查询机构信息
     *
     * @param cfjgmc
     * @return
     */
    SysOrg searchOrgInfoByOrgName(String cfjgmc);

    /**
     * 查询案件缴纳状态信息
     *
     * @param eventId
     * @return
     */
    FjjnmxVo searchFjjnmxByAjxxid(String eventId);

    /**
     * 分页查询轻微免罚行政处罚信息（受案时间在2021年7月15日0时0分始至当前时间）
     *
     * @param current
     * @param size
     * @param ajxxVO
     * @return
     */
    Page<AjxxVO> searchXzcfInfoForQwmf(long current, long size, AjxxVO ajxxVO);

    /**
     * 轻微免罚行政处罚信息个数
     *
     * @param ajxxVO
     * @return
     */
    Integer searchXzcfInfoForQwmfCount(AjxxVO ajxxVO);

    /**
     * 分页查询承诺轻罚行政处罚信息(当前事项的)
     *
     * @param current
     * @param size
     * @param ajxxVO
     * @return
     */
    Page<AjxxVO> searchXzcfInfoForCnqf(long current, long size, AjxxVO ajxxVO);

    /**
     * 查询当前事项承诺轻罚记录个数
     *
     * @param ajxxVO
     * @return
     */
    Integer searchXzcfInfoForCnqfCount(AjxxVO ajxxVO);
}

