package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjsqxgjlVO;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjxgVO;
import com.kdgcsoft.rdc.document.service.vo.DocumentValueHisEntity;

import java.util.List;

/**
 * @Description: 案件修改接口
 * @Author: zd
 * @Date: 2020/7/24
 */
public interface AjxgService {

    /**
     * 案件申请修改分页查询
     *
     * @param ajxgVOPage
     * @param ajxgVO
     * @return
     */
    Page<AjxgVO> searchAjsqxgjlPage(Page<AjxgVO> ajxgVOPage, AjxgVO ajxgVO);

    /**
     * 案件申请修改审批数量统计--首页Echarts统计
     *
     * @param ajxgVO
     * @return
     */
    List<String[]> getAjsqxgCountByOrgId(AjxgVO ajxgVO);

    /**
     * 查询未修改记录
     *
     * @param valueId
     * @return
     */
    AjsqxgjlVO searchWxgjlByValueId(String valueId);

    /**
     * 根据主键更新
     *
     * @param vo
     * @return
     */
    boolean updateById(AjsqxgjlVO vo);

    /**
     * 新增
     *
     * @param vo
     */
    boolean insert(AjsqxgjlVO vo);

    /**
     * 根据主键查询
     *
     * @param ajsqxgId
     * @return
     */
    AjsqxgjlVO searchById(String ajsqxgId);

    /**
     * 同步申请修改旧数据
     */
    void syncData();

    /**
     * 根据VALUE_ID和VERSION_NUMBER查询
     * @param ajsqxgjlVO
     * @return
     */
    DocumentValueHisEntity searchDocHisByValueIdAndVersionNumber(AjsqxgjlVO ajsqxgjlVO);
}
