package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity.AjxxVO;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 案件查询
 *
 * @author mpp
 */
public interface AjcxService {

    /**
     * 案件查询
     *
     * @param page
     * @param ajxxVO
     * @return
     */
    Page<AjxxVO> ajcxPage(Page<AjxxVO> page, AjxxVO ajxxVO);

    /**
     * 违法记录查询--执法公示
     *
     * @param page
     * @param ajxxVO
     * @return
     */
    Page<AjxxVO> ajcxPageForZfgs(Page<AjxxVO> page, AjxxVO ajxxVO);

    /**
     * 非现场案件查询
     *
     * @param page
     * @param ajxxVO
     * @return
     */
    Page<AjxxVO> fxcAjcxPage(Page<AjxxVO> page, AjxxVO ajxxVO);

    /**
     * list结果集
     *
     * @param ajxxVO
     * @return
     */
    List<AjxxVO> ajcxList(AjxxVO ajxxVO);

    /**
     * 根据id获取
     *
     * @param ajxxid
     * @return
     */
    AjxxVO getById(String ajxxid);

    /**
     * 根据案件信息id查询详情（含执法依据）
     *
     * @param ajxxid
     * @return
     */
    AjxxVO searchByAjxxId(String ajxxid);

    /**
     * 根据案件信息id查询详情-执法公示（非现场执法案件查询车辆超限信息、电子证据）
     *
     * @param ajxxid
     * @return
     */
    HashMap<String, Object> searchByAjxxIdForZfgs(String ajxxid);

    /**
     * 行政处罚卷宗查询（年份、机构id，查询已办结处罚案件--分析研判）
     *
     * @param ajxxVO （nf：年份，sajgid：受案机构id）
     * @return
     */
    List<AjxxVO> searchXzcfjzList(AjxxVO ajxxVO);

    /**
     * 行政强制卷宗查询（年份、机构id，查询已办结处罚案件--分析研判）
     *
     * @param ajxxVO （nf：年份，sajgid：受案机构id）
     * @return
     */
    List<AjxxVO> searchXzqzjzList(AjxxVO ajxxVO);

    /**
     * 行政处罚分页查询
     *
     * @param ajxxVO
     * @return
     */
    Page<AjxxVO> searchXzcfPage(Page<AjxxVO> page, AjxxVO ajxxVO);

    /**
     * 行政强制分页查询
     *
     * @param page
     * @param ajxxVO
     * @return
     */
    Page<AjxxVO> searchXzqzPage(Page<AjxxVO> page, AjxxVO ajxxVO);

    /**
     * 行政处罚个数
     *
     * @param ajxxVO
     * @return
     */
    Integer countForXzcf(AjxxVO ajxxVO);

    /**
     * 行政强制个数
     *
     * @param ajxxVO
     * @return
     */
    Integer countForXzqz(AjxxVO ajxxVO);

    /**
     * 当事人版app违法记录查询
     *
     * @param ajxxVO
     * @return
     */
    List<AjxxVO> searchWfjlForDsr(AjxxVO ajxxVO);

    /**
     * 执法人员个人首页查询办件数量 办理中
     *
     * @param sj
     * @param zfryid
     * @return
     */
    Integer queryBjQkCfBlIng(String sj, String zfryid);

    /**
     * 执法人员个人首页查询办件数量 办结
     *
     * @param sj
     * @param zfryid
     * @return
     */
    Integer queryBjQkCfBjEnd(String sj, String zfryid);

    /**
     * 强制办理中
     *
     * @param sj
     * @param zfryid
     * @return
     */
    Integer queryBjQkQzBlIng(String sj, String zfryid);

    /**
     * 强制办结
     *
     * @param sj
     * @param zfryid
     * @return
     */
    Integer queryBjQkQzBjEnd(String sj, String zfryid);

    /**
     * 行政处罚案件数量统计--分析研判
     * @param ajxxVO
     * @return
     */
    Map<String, Integer> xzcfajslCount(AjxxVO ajxxVO);

    /**
     * 案件办理状态信息数量统计
     * @param ajxxVO 案件信息实体类
     * @return
     */
    Integer getXzcfCountByOrgId (AjxxVO ajxxVO);

}
