package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 预警纠错
 * @author ZD
 * @since 2020-07-16
 */
@Data
@TableName("XTBA_J_YJJC")
public class YjjcVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 预警纠错id
     */
    @TableId
    private String yjjcid;

    /**
     * 案件信息id
     */
    private String ajxxid;

    /**
     * 案号
     */
    private String ah;

    /**
     * 案件类别
     */
    private String ajlbdm;

    /**
     * 违法事项
     */
    private String wfsx;

    /**
     * 申请人
     */
    private String sqr;

    /**
     * 申请时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date sqsj;

    /**
     * 纠错类型
     */
    private String jclx;

    /**
     * 纠错内容
     */
    private String jcnr;

    /**
     * 纠错日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date jcrq;

    /**
     * 回复
     */
    private String hf;

    /**
     * 纠错状态
     */
    private String jczt;

    /**
     * 违法当事人
     */
    private String wfdsr;

    /**
     * 受案时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date sasj;

    /**
     * 纠错时间起
     */
    @TableField(exist = false)
    private String jcsjStart;
    /**
     * 纠错时间止
     */
    @TableField(exist = false)
    private String jcsjEnd;
    /**
     * 受案时间起
     */
    @TableField(exist = false)
    private String sasjStart;
    /**
     * 受案时间止
     */
    @TableField(exist = false)
    private String sasjEnd;
    /**
     * 受案机构id
     */
    @TableField(exist = false)
    private String sajgid;

    /**
     * 申请日期
     */
    @TableField(exist = false)
    private String sqrqStr;
    /**
     * 纠错日期
     */
    @TableField(exist = false)
    private String jcrqStr;
    /**
     * 受案日期
     */
    @TableField(exist = false)
    private String sasjStr;


    @Override
    public String getId() {
        return yjjcid;
    }

    @Override
    public void setId(String id) {
        this.yjjcid = id;
    }


}
