package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 违规信息实体类
 *
 * @author zd
 * @since 2020-08-04
 */
@Data
@TableName("XTBA_J_WGXX")
public class WgxxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    @TableId
    private String wgxxid;

    /**
     * 线索编号
     */
    private String xsbh;

    /**
     * 违规对象
     */
    private String wgdx;

    /**
     * 标题
     */
    private String bt;

    /**
     * 业户名称
     */
    private String yhmc;

    /**
     * 社会信用代码
     */
    private String tyshxydm;

    /**
     * 车船号牌
     */
    private String cph;

    /**
     * 车牌颜色
     */
    private String cpys;

    /**
     * 当事人
     */
    private String dsr;

    /**
     * 联系电话
     */
    private String lxdh;

    /**
     * 身份证号
     */
    private String sfzh;

    /**
     * 违法开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date kssj;

    /**
     * 终止时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date zzsj;

    /**
     * 经营许可证号
     */
    private String jyxkzh;

    /**
     * 地点
     */
    private String dd;

    /**
     * 违规事项
     */
    private String wgsx;

    /**
     * 经度
     */
    private String jd;

    /**
     * 纬度
     */
    private String wd;

    /**
     * 备注
     */
    private String bz;

    /**
     * 事件id
     */
    private String cfsjid;

    /**
     * 删除状态
     */
    private String deleteFlag;

    /**
     * 组织机构id
     */
    private String orgId;

    /**
     * 职权项目id
     */
    private String zqxmid;

    /**
     * 线索处理状态
     */
    private String xsclztdm;

    /**
     * 创建时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 更新时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /**
     * 办件状态
     */
    @TableField(exist = false)
    private String bjzt;

    /**
     * 办件状态编码
     */
    @TableField(exist = false)
    private String bjztbm;

    /**
     * 附件信息
     */
    @TableField(exist = false)
    private List<Map<String, Object>> fjlist;

    /**
     * 时间
     */
    @TableField(exist = false)
    private String[] sj;

    /**
     * 状态
     */
    @TableField(exist = false)
    private String ajztdm;

    /**
     * 开始时间起
     */
    @TableField(exist = false)
    private String kssjQi;

    /**
     * 开始时间止
     */
    @TableField(exist = false)
    private String kssjZhi;

    /**
     * 制作时间起
     */
    @TableField(exist = false)
    private String zzsjQi;

    /**
     * 制作时间止
     */
    @TableField(exist = false)
    private String zzsjZhi;

    /**
     * 案号
     */
    @TableField(exist = false)
    private String ah;

    /**
     * 流水号
     */
    @TableField(exist = false)
    private String sjlsh;

    /**
     *执法门类代码
     */
    @TableField(exist = false)
    private String zfmlCode;

    /**
     *职权项目版本号
     */
    @TableField(exist = false)
    private String zqxmbbh;

    /**
     *职权项目名称
     */
    @TableField(exist = false)
    private String zqxmmc;

    /**
     *案件信息id
     */
    private String ajxxid;

    /**
     *gzlid
     */
    @TableField(exist = false)
    private String gzlid;

    /**
     *hjid
     */
    @TableField(exist = false)
    private String hjid;

    /**
     *hddyid
     */
    @TableField(exist = false)
    private String hddyid;

    /**
     *hjmc
     */
    @TableField(exist = false)
    private String hjmc;

    /**
     *mainProcessInstId
     */
    @TableField(exist = false)
    private String mainProcessInstId;

    /**
     *ahOrlsh
     */
    @TableField(exist = false)
    private String ahOrlsh;

    /**
     *ahOrlsh
     */
    @TableField(exist = false)
    private String bj;

    /**
     *zqxmid2
     */
    @TableField(exist = false)
    private String zqxmid2;

    @TableField(exist = false)
    private SysUser sysUser;

    @Override
    public String getId() {
        return wgxxid;
    }

    @Override
    public void setId(String id) {
        this.wgxxid  = id;
    }
}
