package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 违法车辆信息
 *
 * @author zd
 * @since 2020-01-17
 */
@Data
@TableName("XTBA_J_WFCL")
public class WfclVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 违法车辆ID
     */
    @TableId("WFCLID")
    private String wfclid;

    /**
     * 车辆信息来源代码
     */
    private String clxxlydm;

    /**
     * AJXXID
     */
    private String ajxxid;

    /**
     * 车辆类型代码
     */
    private String clxldm;

    /**
     * 车牌颜色代码
     */
    private String cpysdm;

    /**
     * 挂车号牌
     */
    private String gchp;

    /**
     * 入户日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rhrq;

    /**
     * 出厂日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date ccrq;

    /**
     * 车主姓名
     */
    private String czxm;

    /**
     * 车主地址
     */
    private String czdz;

    /**
     * 车主电话
     */
    private Long czdh;

    /**
     * 车籍地点
     */
    private String cjdd;

    /**
     * 道路运输证号
     */
    private String dlyszh;

    /**
     * 车辆营运证
     */
    private String clyyz;

    /**
     * 车辆营运证状态
     */
    private String clyyzzt;

    /**
     * 道路运输证核发单位
     */
    private String dlyszhfdw;

    /**
     * 道路运输经营许可证
     */
    private String dlysjyxkz;

    /**
     * 道路运输经营许可证状态
     */
    private String dlysjyxkzzt;

    /**
     * 车牌颜色
     */
    private String cpys;

    /**
     * 厂牌型号
     */
    private String cpxh;

    /**
     * 车牌号码
     */
    private String cphm;

    /**
     * 车长
     */
    private Double cc;

    /**
     * 车高
     */
    private Double cg;

    /**
     * 车宽
     */
    private Double ck;

    /**
     * 车身颜色
     */
    private String csys;

    /**
     * 核定吨（座）位
     */
    private Double hddzw;

    /**
     * 车辆识别号
     */
    private String clsbh;

    /**
     * 车架号
     */
    private String cjh;

    /**
     * 发动机号
     */
    private String fdjh;

    /********************** 非表中字段 ***********************/
    @TableField(exist = false)
    private String clxxid;

    /**
     * 业户名称
     * @return
     */
    @TableField(exist = false)
    private String yhmc;

    /**
     * 经营许可证号
     * @return
     */
    @TableField(exist = false)
    private String jyxkzh;

    /**
     * 业户类别代码
     * @return
     */
    @TableField(exist = false)
    private String yhlbdm;

    /**
     * 发证机构
     */
    @TableField(exist = false)
    private String fzjg;

    /**
     * 发证日期str
     */
    @TableField(exist = false)
    private String fzrqStr;

    /**
     * 有效期止
     */
    @TableField(exist = false)
    private String yxqzStr;

    /**
     * 年审状态代码
     */
    @TableField(exist = false)
    private String nsztdm;

    /**
     * 年审状态代码字符串
     */
    @TableField(exist = false)
    private String[] nsztdms;

    /**
     * 车辆状态代码
     */
    @TableField(exist = false)
    private String clztdm;

    /**
     * 车辆状态代码字符串
     */
    @TableField(exist = false)
    private String[] clztdms;

    /**
     * 驱动方式代码
     */
    @TableField(exist = false)
    private String qdfsdm;

    /**
     * 燃料类型代码
     */
    @TableField(exist = false)
    private String rllxdm;

    /**
     * 整备质量
     */
    @TableField(exist = false)
    private Double zbzl;

    /**
     * 总质量
     */
    @TableField(exist = false)
    private Double zzl;

    /**
     * 登记日期
     */
    @TableField(exist = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date djrq;

    /**
     * 车辆技术等级代码
     */
    @TableField(exist = false)
    private String cljsdjdm;

    /**
     * 车轴数
     */
    @TableField(exist = false)
    private Long czs;

    /**
     * 轴距
     */
    @TableField(exist = false)
    private Long zj;

    /**
     * 安装定位系统代码
     */
    @TableField(exist = false)
    private String azdwxtdm;

    /**
     * 经营范围
     */
    @TableField(exist = false)
    private String jyfw;

    /**
     * 审验年度
     */
    @TableField(exist = false)
    private String nsnd;

    /**
     * 年审日期
     */
    @TableField(exist = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date nsrq;

    /**
     * 年审有效期至
     */
    @TableField(exist = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date nsyxqz;

    /**
     * 二维间隔月数
     */
    @TableField(exist = false)
    private Long ewjgys;

    /**
     * 下次二维日期
     */
    @TableField(exist = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date xcewrq;

    /**
     * djrqStr
     * @return
     */
    @TableField(exist = false)
    private String djrqStr;

    /**
     * nsrqStr
     * @return
     */
    @TableField(exist = false)
    private String nsrqStr;

    /**
     * xcewrqStr
     * @return
     */
    @TableField(exist = false)
    private String xcewrqStr;

    /**
     * nsyxqzStr
     * @return
     */
    @TableField(exist = false)
    private String nsyxqzStr;

    /**
     * 业户信息id
     * @return
     */
    @TableField(exist = false)
    private String yhxxid;

    /**
     * 行政区划代码
     * @return
     */
    @TableField(exist = false)
    private String xzqhdm;

    /**
     * 行政区划名称
     * @return
     */
    @TableField(exist = false)
    private String xzqhmc;

    /**
     * 车牌颜色加车牌号码
     * @return
     */
    @TableField(exist = false)
    private String yshm;

    @Override
    public String getId() {
        return wfclid;
    }

    @Override
    public void setId(String id) {
        this.wfclid = id;
    }


}
