package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 投诉举报VO
 * </p>
 *
 * @author 黄宇
 * @since 2020-02-24
 */
@Data
@TableName("XTBA_J_TSJB")
public class TsJbVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 投诉举报ID
     */
    @TableId
    private String tsjbid;

    /**
     * 投诉类型代码
     */
    private String tslxdm;
    /**
     * 投诉类型代码文文字内容
     */
    @TableField(exist = false)
    private String tslxdmNr;

    /**
     * 投诉举报状态代码
     */
    private String tsjbztdm;
    /**
     * 信访来源代码
     */
    private String xflydm;
    /**
     * 信访来源代码文字内容
     */
    @TableField(exist = false)
    private String xflydmNr;
    /**
     * 受理编号
     */
    private String slbh;
    /**
     * 投诉举报人姓名
     */
    private String tsjbrxm;
    /**
     * 投诉举报人证件号码
     */
    private String tsjbrzjhm;
    /**
     * 联系手机
     */
    private String lxsj;
    /**
     *
     * 所在区域
     */
    private String szqy;
    /**
     *
     * 所在区域
     */
    @TableField(exist = false)
    private String szqyStr;
    /**
     * 联系地址
     */
    private String lxdz;
    /**
     * 电子邮件
     */
    private String dzyj;
    /**
     * 线索处置人id
     */
    private String xsczrid;
    /**
     * 线索处置时间
     */
    private Date xsczsj;
    /**
     * 转入立案登记人id
     */
    private String zrladjryid;
    /**
     * 转入立案登记时间
     */
    private Date zrladjsj;
    /**
     * 投诉举报日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date tsjbrq;
    /**
     * 投诉举报日期 返回前台
     */
    @TableField(exist = false)
    private String tsjbrqStr;
    /**
     * 投诉举报日期开始 用于接收前台数据
     */
    @TableField(exist = false)
    private String tsjbrqStart;
    /**
     * 投诉举报日期结束  用于接收前台数据
     */
    @TableField(exist = false)
    private String tsjbrqEnd;

    /**
     * 标题
     */
    private String bt;
    /**
     * 投诉举报具体内容
     */
    private String tsjbjtnr;
    /**
     * 附件id 从前台接收一个投诉举报信息所包含的附件id
     */
    @TableField(exist = false)
    private String[] fjid;
    /**
     * 标记 用于更新投诉举报状态操作
     */
    @TableField(exist = false)
    private String flag;
    /**
     * 材料名称
     */
    @TableField(exist = false)
    private String clmc;
    /**
     * 保存路径
     */
    @TableField(exist = false)
    private String bclj;
    /**
     * 存储材料路径
     */
    @TableField(exist = false)
    private List bcljArr=new ArrayList();
    /**
     * 存储材料名称
     */
    @TableField(exist = false)
    private List clmcArr=new ArrayList();
    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List fjidArr=new ArrayList();
    /**
     * 投诉举报状态字典值
     */
    @TableField(exist = false)
    private String tsjbztdmCode;

    /**
     * 附件类型
     */
    @TableField(exist = false)
    private String fjlx;
    /**
     * 附件信息json数据
     */
    @TableField(exist = false)
    private String fjJson;

    /**
     * 举报投诉编码数组（其它子系统查询需要传多个编码，进行查询）
     */
    @TableField(exist = false)
    private String[] tsjbztArray;

    /**
     * 案号
     */
    @TableField(exist = false)
    private String ah;

    /**
     * 流水号
     */
    @TableField(exist = false)
    private String sjlsh;

    /**
     *执法门类代码
     */
    @TableField(exist = false)
    private String zfmlCode;

    /**
     *职权项目id
     */
    @TableField(exist = false)
    private String zqxmid;

    /**
     *职权项目版本号
     */
    @TableField(exist = false)
    private String zqxmbbh;

    /**
     *职权项目名称
     */
    @TableField(exist = false)
    private String zqxmmc;

    /**
     *案件信息id
     */
    private String ajxxid;

    /**
     *gzlid
     */
    @TableField(exist = false)
    private String gzlid;

    /**
     *hjid
     */
    @TableField(exist = false)
    private String hjid;

    /**
     *hddyid
     */
    @TableField(exist = false)
    private String hddyid;

    /**
     *hjmc
     */
    @TableField(exist = false)
    private String hjmc;

    /**
     *mainProcessInstId
     */
    @TableField(exist = false)
    private String mainProcessInstId;

    /**
     *ahOrlsh
     */
    @TableField(exist = false)
    private String ahOrlsh;

    /**
     *ahOrlsh
     */
    @TableField(exist = false)
    private String bj;

    /**
     *案件状态代码
     */
    @TableField(exist = false)
    private String ajztdm;

    @Override
    public String getId() {
        return tsjbid;
    }

    @Override
    public void setId(String id) {
        this.tsjbid = id;
    }

}
