package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 强制措施事件表实体类
 *
 * @author zd
 * @since 2020-04-28
 */
@Data
@TableName("XTBA_J_QZCSSJ")
public class QzcssjVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 强制措施事件id
     */
    @TableId("QZCSSJID")
    private String qzcssjid;

    /**
     * 案件信息id
     */
    private String ajxxid;

    /**
     * 案由
     */
    private String ay;

    /**
     * 受案事件
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date sasj;

    /**
     * 执法机构
     */
    private String zfjg;

    /**
     * 决定事件
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date jdrq;

    /**
     * 决定书案号
     */
    private String jdsah;

    /**
     * 强制措施
     */
    private String qzcs;

    /**
     * 申请时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date sqsj;

    /**
     * 锁状态
     */
    private String szt;

    /**
     * 立案时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date lasj;

    /**
     * 行政区划id
     */
    private String xzqhid;

    /**
     * 组织机构id
     */
    private String zzjgid;

    /**
     * 部门id
     */
    private String bmid;

    /**
     * 补办状态
     */
    private String bbzt;

    /**
     * 机构简称
     */
    private String jgjc;

    /**
     * 年份
     */
    private String nf;

    /**
     * 职权项目id
     */
    private String zqxmid;

    /**
     * 案号
     */
    private String ah;

    /**
     * 审批机构id
     */
    private String spjgid;

    /**
     * 车辆id
     */
    private String clid;

    /**
     * 职权项目版本号
     */
    private Long zqxmbbh;

    /**
     * 职权项目名称
     */
    private String zqxmmc;

    private Long mainProcessInstId;

    /**
     * 工作流id
     */
    private Long gzlid;

    /**
     * 案件类别代码
     */
    private String ajlbdm;

    /**
     * 案件发生时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date ajfssj;

    /**
     * 案件发生地点
     */
    private String ajfsdd;

    /**
     * 案件发生地点经度
     */
    private String ajfsddjd;

    /**
     * 案件发生地点维度
     */
    private String ajfsddwd;

    /**
     * 调查人员1
     */
    private String dcryxm1;

    /**
     * 调查人员1机构ID
     */
    private String dcry1jgid;

    /**
     * 调查人员1机构名称
     */
    private String dcry1jgmc;

    /**
     * 调查人员2
     */
    private String dcryxm2;

    /**
     * 调查人员2机构ID
     */
    private String dcry2jgid;

    /**
     * 调查人员2机构名称
     */
    private String dcry2jgmc;

    /**
     * 调查人员执法证号1
     */
    private String dcryzfzh1;

    /**
     * 调查人员执法证号2
     */
    private String dcryzfzh2;

    /**
     * 受案机构ID
     */
    private String sajgid;

    /**
     * 受案机构名称
     */
    private String sajgmc;

    /**
     * 车船号
     */
    private String cch;

    /**
     * 执法机关ID
     */
    private String zfjgid;

    /**
     * 执法机关名称
     */
    private String zfjgmc;

    /**
     * 强制扣押到期
     */
    private String qzkydq;

    /**
     * 申请人ID
     */
    private String sqrid;

    /**
     * 申请人姓名
     */
    private String sqrxm;

    /**
     * 申请人执法证号
     */
    private String sqrzfzh;

    /**************************查询字段*****************************/

    /**
     * 环节id
     */
    @TableField(exist = false)
    private String hjid;

    /**
     * 环节定义id
     */
    @TableField(exist = false)
    private String hddyid;

    /**
     * 环节名称
     */
    @TableField(exist = false)
    private String hjmc;

    /**
     * 申请时间起
     */
    @TableField(exist = false)
    private String sqsjQi;

    /**
     * 申请时间止
     */
    @TableField(exist = false)
    private String sqsjZhi;

    /**
     * 申请时间字符串
     */
    @TableField(exist = false)
    private String sqsjStr;

    /**
     * 执法门类编码
     */
    @TableField(exist = false)
    private String zfmlCode;

    /**
     * 调查人员
     */
    @TableField(exist = false)
    private String dcryAll;

    /*************************** 立案登记表单数据 *****************/
    /**
     * 案件基础信息
     */
    @TableField(exist = false)
    private String baseform;
    /**
     * 当事人信息
     */
    @TableField(exist = false)
    private String personalform;
    /**
     * 驾驶员信息
     */
    @TableField(exist = false)
    private String driverform;
    /**
     * 船舶信息
     */
    @TableField(exist = false)
    private String boatform;
    /**
     * 车辆信息
     */
    @TableField(exist = false)
    private String carform;
    /**
     * 查询范围(查询范围 01 本单位 02 下级单位 00 本单位及下级单位)
     */
    @TableField(exist = false)
    private String cxfw;
    /**
     * 办结状态
     */
    @TableField(exist = false)
    private String bjzt;
    /**
     * 案件发生地点名称
     */
    private String ajfsddmc;
    /**
     * 当事人名称
     */
    private String dsrmc;
    /**
     * 顺序号
     */
    private Long shunxu;

    /**
     * 事件流水号
     */
    private Long sjlsh;
    /**
     * 案件状态代码
     */
    private String ajztdm;
    /**
     * 案件编号
     */
    private String ajbh;

    /**
     * 车型
     */
    @TableField(exist = false)
    private String clxldm;

    /**
     * 理由
     */
    @TableField(exist = false)
    private String liYou;

    /**
     * 种类
     */
    @TableField(exist = false)
    private String zhongLei;

    /**
     * 案件类别代码
     */
    @TableField(exist = false)
    private String ajlbdmCode;

    /**
     * 创建时间
     */
    @TableField(exist = false)
    private String[] cjrq;
    /**
     * 创建时间字符串
     */
    @TableField(exist = false)
    private String cjrqStr;
    /**
     * 创建时间起
     */
    @TableField(exist = false)
    private String cjrqQi;
    /**
     * 创建时间止
     */
    @TableField(exist = false)
    private String cjrqZhi;
    /**
     * 创建时间止
     */
    @TableField(exist = false)
    private String[] zfmls;

    @Override
    public String getId() {
        return qzcssjid;
    }

    @Override
    public void setId(String id) {
        this.qzcssjid = id;
    }


}
