package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 停车场信息
 */
@Data
@TableName("XTBA_J_TCCXX")
public class KcxxglVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 停车场id
     */
    @TableId
        private String tccid;

    /**
     * 行政区划编码
     */
    private String xzqhbm;

    /**
     * 行政区划名称
     */
    private String xzqhmc;

    /**
     * 停车场名称
     */
    private String tccmc;

    /**
     * 停车场地址
     */
    private String tccdz;

    /**
     * 停车位总数
     */
    private String tcwzs;

    /**
     * 停车场编号
     */
    private String tccbh;

    /**
     * 联系人
     */
    private String lxr;

    /**
     * 联系人电话
     */
    private String lxrdh;

    /**
     * 固话号码
     */
    private String ghhm;

    /**
     * 扣押时间
     */
    @TableField(exist = false)
    private String kysjStr;

    /**
     * 扣押时间
     */
    @TableField(exist = false)
    private Date kysj;

    /**
     * 进去时间
     */
    @TableField(exist = false)
    private String jrsjStr;

    /**
     * 进去时间
     */
    @TableField(exist = false)
    private Date jrsj;

    /**
     * 放出时间
     */
    @TableField(exist = false)
    private String fcsjStr;

    /**
     * 放出时间
     */
    @TableField(exist = false)
    private Date fcsj;

    /**
     * 驾驶员
     */
    @TableField(exist = false)
    private String jsy;

    /**
     * 放车单编号
     */
    @TableField(exist = false)
    private String fcdbh;

    /**
     * 扣车号牌
     */
    @TableField(exist = false)
    private String kchp;

    /**
     * 扣车明细id
     */
    @TableField(exist = false)
    private String kcmxid;

    /**
     * 强制措施案号
     */
    @TableField(exist = false)
    private String qcah;

    /**
     * 涉案数
     */
    @TableField(exist = false)
    private String ajs;

    /**
     *
     * @return
     */
    @Override
    public String getId() {
        return tccid;
    }

    @Override
    public void setId(String id) {
        this.tccid = id;
    }
}
