package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;


/**
 * <p>
 * 车辆超限信息
 * </p>
 *
 * @author zd
 * @since 2020-01-17
 */
@Data
@TableName("XTBA_J_CLCXXX")
public class ClcxxxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 车辆超限信息id
     */
    @TableId("CLCXXXID")
    private String clcxxxid;

    /**
     * 货运车型代码
     */
    private String hycxdm;

    /**
     * AJXXID
     */
    private String ajxxid;

    /**
     * 货物源头区域编码
     */
    private String hwytqybm;

    /**
     * 货物源头区域名称
     */
    private String hwtytqymc;

    /**
     * 源头单位名称
     */
    private String ytdwmc;

    /**
     * 源头单位地址
     */
    private String ytdwdz;

    /**
     * 源头单位联系方式
     */
    private String ytdwlxfs;

    /**
     * 源头单位负责人
     */
    private String ytdwfzr;

    /**
     * 运载物
     */
    private String yzw;

    /**
     * 装货货场
     */
    private String zhhc;

    /**
     * 车货总重（吨）
     */
    private Double chzz;

    /**
     * 车货总限重（吨）
     */
    private Double chzxz;

    /**
     * 超限重量（吨）
     */
    private Double cxzl;

    /**
     * 车轴数
     */
    private Long czs;

    /**
     * 超限率
     */
    private String cxl;

    /**
     * 是否可以解体
     */
    private String sfkyjt;

    /**
     * 起始地
     */
    private String qsd;

    /**
     * 终点地
     */
    private String zdd;

    /**
     * 从业资格证
     */
    private String cyzgz;

    /**
     * 超限检测单号
     */
    private String cxjcdh;

    /**
     * 是否暴力抗法
     */
    private String sfblkf;

    /**
     * 车辆满足条件
     */
    private String clmztj;

    /**
     * 车货总长（M）
     */
    private Double chzc;

    /**
     * 车货总宽（M）
     */
    private Double chzk;

    /**
     * 车货总高（M）
     */
    private Double chzg;

    /**
     * 车货超长（M）
     */
    private Double chcc;

    /**
     * 车货超高（M）
     */
    private Double chcg;

    /**
     * 车货超宽（M）
     */
    private Double chck;

    /**
     * 车货限长（M）
     */
    private Double chxc;

    /**
     * 车货限宽（M）
     */
    private Double chxk;

    /**
     * 车货限高（M）
     */
    private Double chxg;

    /**
     *受案时间
     */
    @TableField(exist = false)
    private String sasj;

    /**
     * 业户名称
     */
    @TableField(exist = false)
    private String yhmc;

    /**
     * 车牌号码
     */
    @TableField(exist = false)
    private String cphm;

    /**
     * 道路运输证号
     */
    @TableField(exist = false)
    private String dlyszh;

    /**
     * 从业资格证号
     */
    @TableField(exist = false)
    private String cyzgzh;

    /**
     * 业户地址
     */
    @TableField(exist = false)
    private String yhdz;

    /**
     * 法人代表
     */
    @TableField(exist = false)
    private String frdb;

    /**
     * 法人联系电话
     */
    @TableField(exist = false)
    private String frlxdh;

    /**
     * 发证机构
     */
    @TableField(exist = false)
    private String fzjg;

    /**
     * 行政区划名称
     */
    @TableField(exist = false)
    private String xzqhmc;

    /**
     * 首次发证日期
     */
    @TableField(exist = false)
    private String scfzrq;

    /**
     * 发证地市
     */
    @TableField(exist = false)
    private String fzds;

    @TableField(exist = false)
    private String jtzz;

    @TableField(exist = false)
    private String xm;

    @TableField(exist = false)
    private String sfzhm;

    @TableField(exist = false)
    private String lxdh;

    @TableField(exist = false)
    private String zqxmid;

    /**
     * 当事人名称
     */
    @TableField(exist = false)
    private String dsrmc;

    /**
     * 案由
     */
    @TableField(exist = false)
    private String ay;

    /**
     * 职法门类代码
     */
    @TableField(exist = false)
    private String zfmldm;

    @Override
    public String getId() {
        return clcxxxid;
    }

    @Override
    public void setId(String id) {
        this.clcxxxid = id;
    }


}
