package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@TableName("XTBA_J_AJZX")
public class AjzxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 注销案件ID
     */
    @TableId("ZXAJID")
    private String zxajid;

    /**
     * AJXXID
     */
    private String ajxxid;

    /**
     * 案号
     */
    private String ah;

    /**
     * 所属单位
     */
    private String ssdw;

    /**
     * 申请人ID
     */
    private String sqrid;

    /**
     * 申请人姓名
     */
    private String sqrxm;

    /**
     * 申请人执法证号
     */
    private String sqrzfzh;

    /**
     * 申请时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date sqsj;

    /**
     * 申请理由
     */
    private String sqly;

    /**
     * 注销案件类别
     */
    private String zxajlb;

    /**
     * 注销状态
     */
    private String zxzt;

    /**
     * 执行人
     */
    private String zxr;

    /**
     * 执行人ID
     */
    private String zxrid;

    /**
     * 申请时间str
     */
    @TableField(exist = false)
    private String sqsjstr;

    /**
     * 注销时间str
     */
    @TableField(exist = false)
    private String zxsjstr;

    /**
     * 是否为当前年份
     */
    @TableField(exist = false)
    private int isCurrentYear;

    /**
     * 开始申请日期
     */
    @TableField(exist = false)
    private String sqSta;

    /**
     * 结束申请日期
     */
    @TableField(exist = false)
    private String sqEnd;

    /**
     * 回收案号
     */
    @TableField(exist = false)
    private String recyleAh;


    /**
     * 执行时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date zxsj;

    @TableField(exist = false)
    private String jgid;

    private String ssdwid;

    @TableField(exist = false)
    private SysUser sysUser;

    @Override
    public String getId() {
        return zxajid;
    }

    @Override
    public void setId(String id) {
        this.zxajid = id;
    }


}
