package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 
字段说明
是否缴费凭证 是为了涉案金额对账时（线下支付）需要用OCR识别缴费时间和缴费金额等内容

涉案财物登记的附属材料信息，证明财物的真实性
 * </p>
 *
 * @author zhaokai
 * @since 2020-01-16
 */
@Data
@TableName("XTBA_J_AJZJCL")
public class AjzjclVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 案件证据材料ID
     */
    @TableId
    private String ajzjclid;

    /**
     * 数据来源编码
     */
    private String sjlydm;

    /**
     * AJXXID
     */
    private String ajxxid;

    /**
     * 证据类型代码
     */
    private String zjlxdm;

    /**
     * 证据类型编码
     */
    @TableField(exist = false)
    private String zjlxdmCode;

    /**
     * 涉案财物ID
     */
    private String sacwid;

    /**
     * 非现场执法id
     */
    private String fxczfid;

    /**
     * 证据材料格式代码
     */
    private String zjclgsdm;

    /**
     * 证据获取方式代码
     */
    private String zjhqfsdm;

    /**
     * 证据材料名称
     */
    private String zjclmc;

    /**
     * 证据材料说明
     */
    private String zjclsm;

    /**
     * 附件名称
     */
    private String fjmc;

    /**
     * 文件保存路径
     */
    private String wjbclj;

    /**
     * 提取人
     */
    private String tqr;

    /**
     * 提取人执法证号
     */
    private String tqrzfzh;

    /**
     * 提取区域
     */
    private String tqqy;

    /**
     * 提取地点
     */
    private String tqdd;

    /**
     * 提取地点名称
     */
    private String tqddmc;

    /**
     * 提取地点经度
     */
    private Double tqddjd;

    /**
     * 提取地点维度
     */
    private Double tqddwd;

    /**
     * 提取时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date tqsj;

    /**
     * 提取人ID
     */
    private String tqrid;

    /**
     * 机构ID
     */
    private String tqrjgid;

    /**
     * 机构名称
     */
    private String tqrjigmc;

    /**
     * 是否缴费凭证
     */
    private String sfjfpz;

    /**
     * 是否涉案财物材料
     */
    private String sfsacwcl;

    /**
     * 工作流实例ID
     */
    private String gzlslid;

    /**
     * 当前环节ID
     */
    private String dqhjid;

    /**
     * 当前环节名称
     */
    private String dqhjmc;

    /**
     *提取时间str
     * @return
     */
    @TableField(exist = false)
    private String  tqsjStr;

    /**
     *开始提取时间
     */
    @TableField(exist = false)
    private String  tqsjSta;

    /**
     * 结束提取时间
     */
    @TableField(exist = false)
    private String  tqsjEnd;

    /**
     * 案号
     * @return
     */
    @TableField(exist = false)
    private String ah;

    /**
     * 规格
     * @return
     */
    @TableField(exist = false)
    private String gg;

    /**
     * 数量
     * @return
     */
    private String sl;

    /**
     * 投诉举报id
     */
    private String tsjbid;

    /**
     * 提取地点详细
     */
    private String tqddxx;

    /**
     * 附件id，多个逗号拼接
     */
    @TableField(exist = false)
    private String fjid;

    /**
     * 证据材料明细id
     */
    @TableField(exist = false)
    private String zjclmxid;

    /**
     * 材料名称
     */
    @TableField(exist = false)
    private String clmc;

    /**
     * 保存路径
     */
    @TableField(exist = false)
    private String bclj;

    /**
     * 附件id 从前台接收一个信息所包含的附件id
     */
    @TableField(exist = false)
    private String[] fjids;

    /**
     * 存储材料路径
     */
    @TableField(exist = false)
    private List bcljArr=new ArrayList();
    /**
     * 存储材料名称
     */
    @TableField(exist = false)
    private List clmcArr=new ArrayList();
    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List fjidArr=new ArrayList();

    /**
     * 附件信息json字符串
     */
    @TableField(exist = false)
    private String fjJson;

    /**
     * 机构名称
     */
    @TableField(exist = false)
    private String jgmc;

    /**
     * 执法机构id
     */
    @TableField(exist = false)
    private String zfjgid;

    /**
     * 查询范围
     */
    @TableField(exist = false)
    private String cxfw;

    /**
     *
     * @return
     */
    @Override
    public String getId() {
        return ajzjclid;
    }

    @Override
    public void setId(String id) {
        this.ajzjclid = id;
    }


}
