package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 案件信息
 *
 * @author zd
 * @since 2020-01-16
 */
@Data
@TableName("XTBA_J_AJXX")
public class AjxxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 案件信息主键
     */
    @TableId("AJXXID")
    private String ajxxid;

    /**
     * 数据来源编码
     */
    private String sjlydm;

    /**
     * 案件状态代码
     */
    private String ajztdm;

    /**
     * 案件类别代码
     */
    private String ajlbdm;

    /**
     * 行政区划代码
     */
    private String xzqhdm;

    /**
     * 案件来源代码
     */
    private String ajlydm;

    /**
     * 案件编码
     */
    private String ajbh;

    /**
     * 年份
     */
    private String nf;

    /**
     * 案号
     */
    private String ah;

    /**
     * 案件发生时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date ajfssj;

    /**
     * 案件发生地点
     */
    private String ajfsdd;

    /**
     * 违法当事人id
     */
    private String wfdsrid;

    /**
     * 当事人名称
     */
    private String dsrmc;

    /**
     * 违法事实
     */
    private String wfss;

    /**
     * 车船号
     */
    private String cch;

    /**
     * 受案机构id
     */
    private String sajgid;

    /**
     * 受案机构名称
     */
    private String sajgmc;

    /**
     * 案由
     */
    private String ay;

    /**
     * 案件发生地点经度
     */
    private String ajfsddjd;

    /**
     * 案件发生地点纬度
     */
    private String ajfsddwd;

    /**
     * 调查人员执法证号1
     */
    private String dcryzfzh1;

    /**
     * 调查人员执法证号2
     */
    private String dcryzfzh2;

    /**
     * 调查人员1
     */
    private String dcry1;

    /**
     * 调查人员2
     */
    private String dcry2;

    /**
     * 调查人员1机构id
     */
    private String dcry1jgid;

    /**
     * 调查人员1机构名称
     */
    private String dcry1jgmc;

    /**
     * 调查人员2机构id
     */
    private String dcry2jgid;

    /**
     * 调查人员2机构名称
     */
    private String dcry2jgmc;

    /**
     * 处理人员执法证号1
     */
    private String clryzfzh1;

    /**
     * 处理人员执法证号2
     */
    private String clryzfzh2;

    /**
     * 处理人员1
     */
    private String clry1;

    /**
     * 处理人员2
     */
    private String clry2;

    /**
     * 处理人员姓名1
     */
    private String clryxm1;

    /**
     * 处理人员姓名2
     */
    private String clryxm2;

    /**
     * 处理机构id
     */
    private String cljgid;

    /**
     * 处理机构名称
     */
    private String cljgmc;

    /**
     * 执法机关id
     */
    private String zfjgid;

    /**
     * 执法机构名称
     */
    private String zfjgmc;

    /**
     * 受案时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sasj;


    /**
     * 是否立案
     */
    private String sfla;

    /**
     * 立案时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date lasj;

    /**
     * 立案时间数组
     */
    @TableField(exist = false)
    private String[] lasjs;

    /**
     * 立案时间Sta
     */
    @TableField(exist = false)
    private String lasjSta;

    /**
     * 立案时间End
     */
    @TableField(exist = false)
    private String lasjEnd;

    /**
     * 原AJXXID
     */
    @TableField(exist = false)
    private String[] yajxxid;

    /**
     * 立案依据
     */
    private String layj;

    /**
     * 处罚依据
     */
    private String cfyj;

    /**
     * 减轻处罚依据
     */
    private String jqcfyj;

    /**
     * 登记人员id
     */
    private String djryid;

    /**
     * 执法类型
     */
    private String zflx;

    /**
     * 登记人员执法证号
     */
    private String djryzfzh;

    /**
     * 登记人员姓名
     */
    private String djryxm;

    /**
     * 登记人机关名称
     */
    private String djrjgmc;

    /**
     * 登记人机关id
     */
    private String djrjgid;

    /**
     * 工作流实例id
     */
    private String gzlslid;

    /**
     * 结案时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date jasj;

    /**
     * 结案时间
     */
    @TableField(exist = false)
    private String jasjStr;

    /**
     * 立卷时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date ljsj;

    /**
     * 归档时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date gdsj;

    /**
     * 立卷人
     */
    private String ljr;

    /**
     * 归档标识
     */
    private String gdbs;

    /**
     * 存档期限
     */
    private String cdqx;

    /**
     * 职权项目id
     */
    private String zqxmid;

    /**
     * 职权项目版本号
     */
    private Long zqxmbbh;

    /**
     * 职权项目名称
     */
    private String zqxmmc;

    /**
     * 备注
     */
    private String bz;

    /**
     * 调查人员姓名1
     */
    private String dcryxm1;

    /**
     * 调查人员姓名2
     */
    private String dcryxm2;

    /**
     * 顺序号
     */
    private Long shunxu;

    /**
     * 事件流水号
     */
    private Long sjlsh;

    /**
     * 统一支付订单号
     */
    private String billNo;

    /**
     * 处罚机构名称
     */
    private String cfjgmc;

    /**
     * 处罚机构代码
     */
    private String cfjgdm;

    /**
     * 是否轻微免罚(00：不是轻微免罚，01：轻微免罚一类， 02：轻微免 罚二类)
     */
    private String sfqwmf;

    /**
     * 案件分类代码
     */
    private String ajfldm;

    /**
     * 是否承诺轻罚(00：不是承诺轻罚，01：是承诺轻罚)
     */
    private String sfcnqf;


    /****************************** 非表中字段   ******************/
    /**
     * 受案时间字符串
     */
    @TableField(exist = false)
    private String sasjStr;

    /**
     * 调查人员 (逗号拼接)
     */
    @TableField(exist = false)
    private String dcryAll;

    /**
     * 处理人员 (逗号拼接)
     */
    @TableField(exist = false)
    private String clryAll;

    /**
     * 调查结构 (逗号拼接)
     */
    @TableField(exist = false)
    private String dcjgAll;

    /**
     * 受案时间起
     */
    @TableField(exist = false)
    private String sasjQi;
    /**
     * 受案时间止
     */
    @TableField(exist = false)
    private String sasjZhi;

    /**
     * 结案时间起
     */
    @TableField(exist = false)
    private String jasjQi;
    /**
     * 结案时间止
     */
    @TableField(exist = false)
    private String jasjZhi;

    /**
     * 执法门类
     */
    @TableField(exist = false)
    private String zfmldm;

    /**
     * 执法门类编码
     */
    @TableField(exist = false)
    private String zfmlCode;

    /**
     * 案件发生地点名称
     */
    private String ajfsddmc;

    /**
     * 审批机构id（案件当前所处机构）
     */
    private String spjgid;

    /*************************** 立案登记表单数据 *****************/
    /**
     * 案件基础信息
     */
    @TableField(exist = false)
    private String baseform;
    /**
     * 当事人信息
     */
    @TableField(exist = false)
    private String personalform;
    /**
     * 驾驶员信息
     */
    @TableField(exist = false)
    private String driverform;
    /**
     * 船舶信息
     */
    @TableField(exist = false)
    private String boatform;
    /**
     * 车辆信息
     */
    @TableField(exist = false)
    private String carform;
    /**
     * 车辆超限信息
     */
    @TableField(exist = false)
    private String carlimitform;
    /**
     * 执法音视频id，多个逗号拼接
     */
    @TableField(exist = false)
    private String zfyspId;

    /**
     * 处罚决定时间
     */
    @TableField(exist = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date cfjdsj;

    /**
     * 处罚决定时间Sta
     */
    @TableField(exist = false)
    private String cfjdsjSta;

    /**
     * 处罚决定时间End
     */
    @TableField(exist = false)
    private String cfjdsjEnd;

    /**
     * 处罚决定时间数组
     */
    @TableField(exist = false)
    private String[] cfjdsjs;

    /**
     * 处罚决定时间Str
     */
    @TableField(exist = false)
    private String cfjdsjStr;

    /**
     * 处罚决定时间 开始
     */
    @TableField(exist = false)
    private String cfjdsjks;

    /**
     * 处罚决定时间 结束
     */
    @TableField(exist = false)
    private String cfjdsjjs;

    /**
     * 办理时间
     */
    @JSONField(format = "yyyy年MM月dd日")
    @TableField(exist = false)
    private Date blrq;

    /**
     * 处罚金额
     */
    @TableField(exist = false)
    private Double cfje;
    /**
     * 处罚金额
     */
    @TableField(exist = false)
    private Double yfcfje;

    /**
     * 处罚金额
     */
    @TableField(exist = false)
    private Double msje;

    /**
     * 处罚金额+没收金额
     */
    @TableField(exist = false)
    private Double fkje;

    /**
     * 最小处罚金额
     */
    @TableField(exist = false)
    private Double cfjemin;

    /**
     * 最大处罚金额
     */
    @TableField(exist = false)
    private Double cfjemax;

    /**
     * 处罚结果
     */
    @TableField(exist = false)
    private String cfjg;

    /**
     * 是否分期缴纳(0：否， 1：是)
     */
    @TableField(exist = false)
    private String sffqjn;

    /**
     * 罚款缴纳状态
     */
    @TableField(exist = false)
    private String fkjnzt;

    /**
     * 罚金缴费方式
     */
    @TableField(exist = false)
    private String fjjffs;
    /**
     * 投诉举报ID
     */
    @TableField(exist = false)
    private String tsjbid;
    /**
     * 非现场执法数据id
     */
    @TableField(exist = false)
    private String fxczfid;
    /**
     * 标记 用于更新投诉举报状态操作
     */
    @TableField(exist = false)
    private String flag;
    /**
     * 驾驶员姓名
     */
    @TableField(exist = false)
    private String jsyxm;

    /**
     * 驾驶员身份证号
     */
    @TableField(exist = false)
    private String jsysfzh;

    /**
     * 立案时间Str
     */
    @TableField(exist = false)
    private String lasjStr;

    /************************行政处罚信息查询字段****************************/

    /**
     * 社会统一信用代码
     */
    @TableField(exist = false)
    private String shtyyhdm;

    /**
     * 身份证号
     */
    @TableField(exist = false)
    private String sfzh;

    /**
     * 姓名
     */
    @TableField(exist = false)
    private String xm;

    /**
     * 车牌号
     */
    @TableField(exist = false)
    private String cph;

    /**
     * 船舶识别号
     */
    @TableField(exist = false)
    private String cbsbh;

    /**
     * 船舶登记号
     */
    @TableField(exist = false)
    private String cbdjh;

    /**
     * 船舶中文名称
     */
    @TableField(exist = false)
    private String cbzwmc;

    /***************************** 流程相关 **********************************/

    /**
     * 工作流id
     */
    private Long gzlid;

    /**
     * 环节名称
     */
    private String hjmc;

    /**
     * 环节Id
     */
    @TableField(exist = false)
    private String hjid;
    /**
     * 环节定义ID
     */
    @TableField(exist = false)
    private String hddyid;
    private Long mainProcessInstId;

    /**
     * 事件类别（行政处罚：XZCF,行政强制：XZQZ）
     */
    @TableField(exist = false)
    private String eventType;
    /**
     * 办结状态
     */
    @TableField(exist = false)
    private String bjzt;
    /**
     * 查询范围
     */
    @TableField(exist = false)
    private String cxfw;
    /**
     * 机构类别
     */
    @TableField(exist = false)
    private String jglb;
    /**
     * 处罚金额起
     */
    @TableField(exist = false)
    private BigDecimal cfjeqs;
    /**
     * 处罚金额末
     */
    @TableField(exist = false)
    private BigDecimal cfjejs;

    /**
     * 经营许可证号
     */
    @TableField(exist = false)
    private String jyxkzh;

    /**
     * 案件信息ids
     */
    @TableField(exist = false)
    private String ajxxids;

    /**
     * 案件信息id数组
     */
    @TableField(exist = false)
    private String[] ajxxidArray;

    /**
     * 业户名称
     */
    @TableField(exist = false)
    private String yhmc;

    /**
     * 车辆营运证号
     */
    @TableField(exist = false)
    private String clyyz;

    /**
     * 从业资格证号
     */
    @TableField(exist = false)
    private String cyzgzh;

    /**
     * 执法机构
     */
    @TableField(exist = false)
    private String zfjg;

    /**
     * 行政决定时间
     */
    @TableField(exist = false)
    private String xzjdsj;

    /**
     * 行业编码
     */
    @TableField(exist = false)
    private String hyCode;

    /**
     * 车籍地点
     */
    @TableField(exist = false)
    private String ccjd;

    /**
     * 处理人id，多个处理人逗号分隔（处理人为执法人员）
     */
    @TableField(exist = false)
    private String clrId;

    /**
     * 当事人证件号
     */
    @TableField(exist = false)
    private String zjh;

    /**
     * cfje1  处罚金额起
     */
    @TableField(exist = false)
    private String cfje1;

    /**
     * cfje2   处罚金额末
     */
    @TableField(exist = false)
    private String cfje2;

    /**
     * 案处机构id
     */
    @TableField(exist = false)
    private String orgDealId;

    /**
     * 查询指标（1.一般案件 2.注销案件 3.案件有退回操作 4. 省级办理案件 5. 重大案件）--分析研判系统查询条件
     */
    @TableField(exist = false)
    private String cxzb;

    /**
     * 处罚类别集合（多个处罚类别码值逗号分隔）--分析研判系统查询条件
     */
    @TableField(exist = false)
    private String cflbs;
    @TableField(exist = false)
    private String[] cflbArr;

    /**
     * 个人处罚金额--分析研判系统查询条件
     */
    @TableField(exist = false)
    private String grcfje;

    /**
     * 企业处罚金额--分析研判系统查询条件
     */
    @TableField(exist = false)
    private String qycfje;

    /**
     * 行政强制决定--分析研判系统查询条件
     */
    @TableField(exist = false)
    private String xzqzjd;

    /**
     * 时间查询（时间类型 1-今年 2-本月 为空查询全部,默认为空）--分析研判系统查询条件
     */
    @TableField(exist = false)
    private String timeFalg;

    /**
     * 预警风险点
     */
    @TableField(exist = false)
    private String fxd;

    /**
     * 预警点描述
     */
    @TableField(exist = false)
    private String fxdms;

    /**
     * 处罚决定书摘要--执法公示系统查询条件
     */
    @TableField(exist = false)
    private String cfjdszy;

    @TableField(exist = false)
    private String rq;

    @TableField(exist = false)
    private String ajlx;

    @TableField(exist = false)
    private String rqStr;

    @TableField(exist = false)
    private String rqEnd;

    @TableField(exist = false)
    private String workitemname;

    @TableField(exist = false)
    private String sqsj;

    /**
     * 线索id
     */
    @TableField(exist = false)
    private String xsid;

    /**
     * 文书模板名称
     */
    @TableField(exist = false)
    private String wordTemplateName;

    /**
     * 线索类型
     */
    @TableField(exist = false)
    private String xslx;

    /**
     * 是否有推送新文书
     */
    @TableField(exist = false)
    private String sfytsxws;

    /**
     * 违法当事人类别代码（0：法人，1：个人）
     */
    @TableField(exist = false)
    private String wfdsrlbdm;

    /**
     * 违法当事人类别代码（0：法人，1：个人）
     */
    @TableField(exist = false)
    private String valueId;

    @TableField(exist = false)
    private String cout;

    @TableField(exist = false)
    private String jsylxdh;

    @TableField(exist = false)
    private String blzt;

    @TableField(exist = false)
    private String fw;


    /**
     * 缴纳金额
     */
    @TableField(exist = false)
    private Double money;
    /**
     * 总金额
     */
    @TableField(exist = false)
    private Double zje;
    /**
     * 已缴纳金额
     */
    @TableField(exist = false)
    private String yjnje;

    /**
     * 应缴纳金额
     */
    @TableField(exist = false)
    private Double yjn;
    /**
     * 未缴纳金额
     */
    @TableField(exist = false)
    private Double wjn;
    /**
     * 案件登记人
     */
    @TableField(exist = false)
    private String djr;
    /**
     * 车牌号数组
     */
    @TableField(exist = false)
    private String[] cphArray;
    /**
     * 执法门类数组
     */
    @TableField(exist = false)
    private String[] zfmlArray;

    /**
     * 当事人类别代码
     */
    @TableField(exist = false)
    private String dsrlbdm;

    /**
     * 处理结果代码
     */
    @TableField(exist = false)
    private String cljgdm;

    /**
     * 缴纳状态
     */
    @TableField(exist = false)
    private String jnzt;

    /**
     * 缴款识别码
     */
    @TableField(exist = false)
    private String jksbm;

    /**
     * 缴款人
     */
    @TableField(exist = false)
    private String jkr;

    /**
     * 滞纳金
     */
    @TableField(exist = false)
    private String znj;

    /**
     * 是否缴纳
     */
    @TableField(exist = false)
    private String sfjn;

    /**
     * 缴款时间
     */
    @TableField(exist = false)
    private String jfsj;

    /****
     * 是否是远程异地执法( 0:否 1：是)
     */
    @TableField(exist = false)
    private String isYcyd;

    /**
     * 支持轻微免罚
     */
    @TableField(exist = false)
    private String zcqwmf;

    /**
     * 轻微免罚类型
     */
    @TableField(exist = false)
    private String qwmflx;

    /**
     * 支持承诺轻罚
     */
    @TableField(exist = false)
    private String zccnqf;

    @TableField(exist = false)
    private String grhzzzjh;

    /**
     * id数组
     */
    @TableField(exist = false)
    private List<String> idsArr;

    /**
     * 数组
     */
    @TableField(exist = false)
    private List<String> valueArr;

    /**
     * 类型
     */
    @TableField(exist = false)
    private List<String> typeArr;

    @Override
    public String getId() {
        return ajxxid;
    }

    @Override
    public void setId(String id) {
        this.ajxxid = id;
    }


}
