package com.kdgcsoft.jt.xzzf.dubbo.xtba.caseHandle.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 案件修改实体类
 * @Author: zd
 * @Date: 2020/7/24
 */
@Data
public class AjxgVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private String valueHisId;

    /**
     * 案件中的文书id
     */
    private String valueId;

    /**
     * 案件信息id
     */
    private String eventId;

    /**
     * 文书模板id
     */
    private String wordTemplateId;

    /**
     * 文书页面json数据
     */
    private String jsonValue;

    private String pdfKey;

    /**
     * pdf版本
     */
    private String versionNumber;

    /**
     * 申请人
     */
    private String sqr;

    /**
     * 申请日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date sqrq;

    private String sqrqStr;
    private String sqsjStart;
    private String sqsjEnd;

    /**
     * 案号
     */
    private String ah;

    /**
     * 案件类别代码
     */
    private String ajlbdm;

    /**
     * 执法证号
     */
    private String zfzh;

    /**
     * 所属机构
     */
    private String orgName;

    /**
     * 0：弃用  1：启用
     */
    private String isUsed;

    private String creater;
    private String createTime;

    /**
     * 申请修改状态(0:不同意修改，1：同意修改，2：未修改)
     */
    private String xgzt;

    /**
     * 文书名称
     */
    private String docName;

    private String orgId;

    private String orgDealId;

    /**
     * 旧pdf版本
     */
    private String oldVersionNumber;

    /*****
     * 申请修改案件数量统计
     */
    private Integer casecount;

    private String roleId;

    /**
     * 申请理由
     */
    private String sqxgly;

    private SysUser sysUser;

    /**
     * XTBA_J_AJSQXGJL主键id
     */
    private String ajsqxgId;

    /**
     * 同意时间
     */
    private String tyrqStr;

    /**
     * 审批人
     */
    private String spr;

}
