package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysZywj;

/****
 * @className SysZywjService
 * @author ChrisYolanda
 * @description 系统资源文件服务层接口
 * @version 1.0
 * @date 2020-12-10 11:21
 */
public interface SysZywjService {

    /****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<SysZywj> page(Page<SysZywj> page, SysZywj entity);

    /*****
     * 保存资源文件数据
     * @param entity
     * @param isCreate
     * @param user 当前登录用户
     */
    void saveOrUpdate(SysZywj entity, boolean isCreate, SysUser user);

    /*****
     * 获取资源文件信息
     * @param id 主键ID
     * @return
     */
    SysZywj getEntityInfoById(String id);

    /*****
     * 删除资源文件信息
     * @param ids id集合
     * @param user 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 获取资源文件的下一个序号
     * @return
     */
    Integer getZywjNextOrderNo();

    /*****
     * 修改资源文件状态
     * @param ids 主键Id集合
     * @param user
     */
    void modifyStatusDataByIds(String ids, SysUser user);
}
