package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysXzqh;

import java.util.List;

/****
 * @className SysXzqhService
 * @author chris
 * @description 行政区划Service接口层接口
 * @version 1.0
 * @date 2020-03-30 10:23
 */
public interface SysXzqhService {

    /*********
     * 行政区划树
     * @param xzqhId 行政区划树Id
     * @param xzqhdj 行政区划等级（1：省，2：市，3：县、区）
     * @param fanwei 范围：1：查询所有子节点，默认当前节点和下级节点
     * @param filter 关键字过滤
     * @return
     */
    List<TreeDataVo> getXzQhTreeInfo(String xzqhId, String xzqhdj, String fanwei, String filter);

    /*****
     * 获取行政区划信息
     * @param xzqhId 行政区划Id
     * @return
     */
    SysXzqh getEntityInfoById(String xzqhId);

    /*******
     * 根据行政区划id获取整个行政区划名称
     * @param xzqhId 行政区划Id
     * @return
     */
    String getFullXzqhmcById(String xzqhId);

    /*******
     * 行政区划树
     * @param xzqhbm 行政区划编码
     * @param xzqhLevels 过滤行政区划等级（1：省，2：市，3：县、区）
     * @param filter 关键字过滤
     * @return
     */
    List<TreeDataVo> queryScopeRecXzqhTreeData(String xzqhbm, String xzqhLevels, String filter);

    /*******
     * 根据行政区划名称查询
     * @param xzqhmc 行政区划名称
     * @return
     */
    SysXzqh searchInfoByXzqhmc(String xzqhmc);
}
