package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.ZfRyXxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity.ZfryRyxxVo;

import java.util.List;

/****
 * @className SysUserService
 * @author chris
 * @description 系统用户服务层接口
 * @version 1.0
 * @date 2019-12-30 15:35
 */
public interface SysUserService {

    /******
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param filter 关键字
     * @param curUserOrgId 当前登录用户组织机构Id
     * @param isSuperAdmin 当前登录用户是否超级管理员
     * @return
     */
    Page<SysUser> page(Page<SysUser> page, SysUser entity, String filter, String curUserOrgId, boolean isSuperAdmin);

    /******
     * 获取分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @param isSuperAdmin 当前登录用户是否超级管理员
     * @return
     */
    Page<SysUser> roleUsersPage(Page<SysUser> page, SysUser entity, String curUserOrgId, boolean isSuperAdmin);

    /*****
     * 保存用户数据
     * @param entity
     * @param isCreate
     * @param user
     */
    void saveOrUpdate(SysUser entity, boolean isCreate, SysUser user);

    /*****
     * 删除用户信息
     * @param ids
     * @param user
     */
    void deleteDataByIds(String ids, SysUser user);

    /****
     * 获取用户信息
     * @param id 主键ID
     * @return
     */
    SysUser getEntityInfoById(String id);

    /****
     * 根据用户名获取用户信息
     * @param userName
     * @return
     */
    SysUser getEntityInfoByName(String userName);

    /****
     * 根据身份证号获取用户信息
     * @param idCard
     * @return
     */
    SysUser getEntityInfoByIdCard(String idCard);

    /*****
     * 重置密码
     * @param ids 用户id集合
     * @param user 当前登录用户
     */
    void resetPwd(String ids, SysUser user);

    /*****
     * 修改密码
     * @param entity 实体类信息
     * @param user 当前登录用户
     * @param isAdmin 是否超管
     */
    void modifyPwd(SysUser entity, SysUser user, boolean isAdmin);

    /*****
     * 设置用户为超级管理员
     * @param ids
     * @param user 当前登录用户
     */
    void setSuper(String ids, SysUser user);

    /*****
     * 设置用户为运维人员
     * @param ids
     * @param user 当前登录用户
     */
    void setDevOps(String ids, SysUser user);

    /********
     * 获取所有人员信息
     * @return
     */
    List<SysUser> getAll();

    /******
     * 获取部门下用户总数
     * @param deptId
     * @return
     */
    Integer getSysUserCountByDeptId(String deptId);

    /******
     * 获取组织机构下用户总数
     * @param orgId
     * @return
     */
    Integer getSysUserCountByOrgId(String orgId);

    /**
     * app用户登录用户名查询
     *
     * @param username
     * @return
     */
    SysUser appLoginUserByName(String username);

    /**
     * 根据用户名查询用户信息
     *
     * @param userName 用户名
     * @return
     */
    SysUser findUserInfoByName(String userName);

    /******
     * 根据组织机构Id,查询用户信息
     * @param page
     * @param entity
     * @param curUserOrgId 当前登录用户组织机构Id
     * @param showOrgChildUser 是否显示组织机构子集下的用户
     * @return
     */
    Page<SysUser> pageDataByOrgId(Page<SysUser> page, SysUser entity, String curUserOrgId, boolean showOrgChildUser);

    /*******
     * 更新用户状态
     * @param idCards 身证份集合
     * @param userStatus 需要更新的状态
     * @param user 当前登录用户
     */
    void updateEntityInfoUserStatus(String idCards, String userStatus, SysUser user);

    /*****
     * 恢复系统默认密码
     * @param ids 用户id集合
     * @param user 当前登录用户
     */
    void restoreDefaultPwd(String ids, SysUser user);

    /*******
     * 关联系统用户与执法人员信息
     * @param zfryInfo 执法人员信息
     * @param user     当前登录用户
     */
    void relSysUserWithZfryInfoByIdCard(ZfRyXxVO zfryInfo, SysUser user);

    /******
     * 获取最近一小时内变化的用户信息
     * @return
     */
    List<SysUser> queryLastHourEntityInfo();

    /*****
     * 修改用户的用户名
     * @param id 用户主键Id
     * @param newAct 新的用户名
     * @param user 当前登录用户
     */
    void modifyUserAct(String id, String newAct, SysUser user);

    /*****
     * 清除用户登录失败次数
     * @param userIds 用户主键Id集合
     */
    void clearUserFailLoginNumByUserIds(String userIds);

    /*****
     * 递归查询用户下拉框数据
     * @param filter 关键字过滤
     * @param menuCode 菜单编码
     * @param subSysKey 子系统Id
     * @param orgId 组织机构Id
     * @param recType 递归查询方式
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<ComboboxVo> queryRecEntityInfoComboboxByMenuCodeAndOrgId(String filter, String menuCode, String subSysKey, String orgId, String recType, String curUserOrgId);

    /*****
     * 查询用户下拉框数据
     * @param filter 关键字过滤
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<ComboboxVo> queryEntityInfoCombobox(String filter, String curUserOrgId);

    /******
     * 获取执法人员分机号信息
     * @param userId 用户Id
     * @return
     */
    List<ComboboxVo> getZfryPeerInfoByUserId(String userId);

    /******
     * 同步执法人员信息到基础管理系统
     * @param entity 实体类
     * @param curUser 当前登录用户
     */
    void syncZfryInfoToSysUser(ZfryRyxxVo entity, SysUser curUser);

    /******
     * 校正用户信息通过执法人员Id
     * @param userId 用户Id
     * @param zfryId 执法人员Id
     * @param curUser 当前登录用户
     */
    void rectifyUserInfoByZfryId(String userId, String zfryId, SysUser curUser);
}
