package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysRole;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;
import java.util.Map;

/****
 * @className SysUserRoleService
 * @author chris
 * @description 用户角色服务层接口类接口
 * @version 1.0
 * @date 2019-12-27 13:31
 */
public interface SysUserRoleService {

    /*****
     * 获取用户拥有的角色分页信息
     * @param page 分页信息
     * @param entity 角色实体类信息
     * @param userId 用户信息
     * @param isAdmin 是否管理员
     * @return
     */
    Page<SysRole> userOwnRolePage(Page page, SysRole entity, String userId, boolean isAdmin);

    /*****
     * 获取用户拥有的角色列表信息
     * @param entity 角色实体类信息
     * @param userId 用户信息
     * @param isAdmin 是否管理员
     * @return
     */
    List<SysRole> userOwnRoleList(SysRole entity, String userId, boolean isAdmin);

    /*****
     * 获取用户拥有的角色列表信息
     * @param userId 用户信息
     * @return
     */
    List<SysRole> userOwnRoleListByUserId(String userId);

    /*****
     * 获取用户未拥有的角色分页信息
     * @param page 分页信息
     * @param entity 角色实体类信息
     * @param userId 用户信息
     * @param isAdmin 是否管理员
     * @return
     */
    Page<SysRole> userUnOwnRolePage(Page page, SysRole entity, String userId, boolean isAdmin);

    /*****
     * 获取用户未拥有的角色列表信息
     * @param entity 角色实体类信息
     * @param userId 用户信息
     * @param isAdmin 是否管理员
     * @return
     */
    List<SysRole> userUnOwnRoleList(SysRole entity, String userId, boolean isAdmin);

    /*****
     * 查询角色关联的用户分页信息
     * @param page 分页信息
     * @param entity 用户实体类信息
     * @param roleId 角色信息
     * @param isAdmin 是否管理员
     * @param curUserOrgId 当前用户所属组织机构
     * @return
     */
    Page<SysUser> roleRelUserPage(Page page, SysUser entity, String roleId, boolean isAdmin, String curUserOrgId);

    /******
     * 查询特殊角色关联的用户分页信息
     * @param page 分页信息
     * @param sourceType 授权方式
     * @param curUser 当前用户
     * @param entity 用户实体类信息
     * @param isAdmin 是否管理员
     * @param curUserOrgId 当前用户所属组织机构
     * @return
     */
    Page<SysUser> xtbaLeaderRoleRelUserPage(Page page, SysUser entity, String sourceType, SysUser curUser, boolean isAdmin, String curUserOrgId);

    /******
     * 查询特殊角色关联的用户分页信息
     * @param page 分页信息
     * @param curUser 当前用户
     * @param entity 用户实体类信息
     * @param isAdmin 是否管理员
     * @param curUserOrgId 当前用户所属组织机构
     * @return
     */
    Page<SysUser> xtbaLeaderRoleUnRelUserPage(Page page, SysUser entity, SysUser curUser, boolean isAdmin, String curUserOrgId);

    /*****
     * 查询角色关联的用户列表信息
     * @param entity 用户实体类信息
     * @param roleId 角色信息
     * @param isAdmin 是否管理员
     * @param curUserOrgId 当前用户所属组织机构
     * @return
     */
    List<SysUser> roleRelUserList(SysUser entity, String roleId, boolean isAdmin, String curUserOrgId);

    /******
     * 保存用户角色信息
     * @param userId 用户信息Id
     * @param roleIds 角色主键Id集合
     * @param curUser 当前登录用户
     */
    void saveUserRoleRel(String userId, String roleIds, SysUser curUser);

    /******
     * 保存领导授权用户角色信息
     * @param userId 用户信息Id
     * @param roleIds 角色主键Id集合
     * @param leaderUserId 领导用户信息Id
     * @param user 当前登录用户
     */
    void saveLeaderAuthRel(String userId, String roleIds, String leaderUserId, SysUser user);

    /******
     * 保存案件审批授权用户角色信息
     * @param userId 用户信息Id
     * @param roleIds 角色主键Id集合
     * @param leaderUserId 领导用户信息Id
     * @param user 当前登录用户
     */
    void saveCaseApproveAuthRel(String userId, String roleIds, String leaderUserId, SysUser user);

    /******
     * 解除用户角色信息
     * @param roleId 角色主键Id
     * @param userIds 用户信息Id集合
     * @param curUser 当前登录用户
     */
    void relieveUserRoleRel(String roleId, String userIds, SysUser curUser);

    /******
     * 解除用户特殊角色关联关系
     * @param userIds 用户信息Id集合
     * @param curUser 当前登录用户
     */
    void relieveLeaderUserRoleRel(String userIds, SysUser curUser);

    /******
     * 续期用户特殊角色关联关系
     * @param userIds 用户信息Id集合
     * @param leaderUserId 领导用户信息Id
     * @param curUser 当前登录用户
     */
    void renewalLeaderUserRoleRel(String userIds, String leaderUserId, SysUser curUser);

    /******
     * 批量授权用户特殊角色关联关系
     * @param userIds 用户信息Id集合
     * @param leaderUserId 领导用户信息Id
     * @param curUser 当前登录用户
     */
    void batchAuthUserLeaderRole(String userIds, String leaderUserId, SysUser curUser);

    /*****
     * 查询角色关联用户总数
     * @param roleId 角色主键Id
     * @return
     */
    Integer queryUserRoleRelCountByRoleId(String roleId);

    /*****
     * 删除用户普通角色信息
     * @param userId 用户信息Id
     * @param curUser 当前登录用户
     * @return
     */
    void deleteOrdinaryUserRoleRelByUserId(String userId, SysUser curUser);

    /*****
     * 删除用户所有角色信息
     * @param userId 用户信息Id
     * @param curUser 当前登录用户
     * @return
     */
    void deleteAllUserRoleRelByUserId(String userId, SysUser curUser);

    /*****
     * 批量复制用户角色信息
     * @param chkUserId 选择的用户Id
     * @param cpyUserIds 赋值的用户Id集合
     * @param curUser 当前登录用户
     * @return
     */
    void batchCopyRole(String chkUserId, String cpyUserIds, SysUser curUser);

    /******
     * 保存用户默认角色信息
     * @param userId 用户信息Id
     * @param curUser 当前登录用户
     */
    void saveUserDefaultRoleRel(String userId, SysUser curUser);

    /*****
     * 判断用户是否具有特定的角色信息
     * @param userId 用户信息Id
     * @param roleIds 角色信息Id集合
     * @param judgeType 判断方式:true-是否包含特殊角色,false-是否包含特殊角色之外的角色
     * @return
     */
    boolean verifyUserOwnSpecRoleInfoByUserId(String userId, List<String> roleIds, boolean judgeType);

    /*****
     * 判断用户是否具有协同办案系统特定的角色信息
     * @param userId 用户信息Id
     * @param subSysId 子系统Id
     * @param roleIds 角色信息Id集合
     * @param judgeType 判断方式:true-是否包含特殊角色,false-是否包含特殊角色之外的角色
     * @return
     */
    boolean verifyUserOwnXtbaSpecRoleInfoByUserId(String userId, List<String> roleIds, String subSysId, boolean judgeType);

    /*****
     * 判断用户是否具有特定的角色之外的角色信息
     * @param userId 用户信息Id
     * @param roleIds 角色信息Id集合
     * @param subSysId 所属子系统Id
     * @param judgeType 判断方式:true-是否包含特殊角色,false-是否包含特殊角色之外的角色
     * @return
     */
    boolean verifyUserOwnSpecRoleOutsideRoleInfoByUserId(String userId, List<String> roleIds, String subSysId, boolean judgeType);

    /*****
     * 获取用户拥有特殊角色列表信息
     * @param entity 角色实体类信息
     * @param userId 用户信息
     * @param curUser 当前登录用户
     * @param isAdmin 是否管理员
     * @return
     */
    List<SysRole> userOwnXtbaLeaderRoleList(SysRole entity, String userId, SysUser curUser, boolean isAdmin);

    /*****
     * 获取用户未拥有特殊角色列表信息
     * @param entity 角色实体类信息
     * @param userId 用户信息
     * @param curUser 当前登录用户
     * @param isAdmin 是否管理员
     * @return
     */
    List<SysRole> userUnOwnXtbaLeaderRoleList(SysRole entity, String userId, SysUser curUser, boolean isAdmin);

    /*****
     * 查询用户已拥有的普通角色信息
     * @param userId 用户Id
     * @return
     */
    List<SysRole> queryEntityInfoOrdinaryRoleByUserId(String userId);

    /*****
     * 查询用户已拥有的领导角色信息
     * @param userId 用户Id
     * @param specRoleIds 领导角色Id集合
     * @return
     */
    List<SysRole> queryLeaderRoleRelEntityInfoByUserIdAndRoleIds(String userId, List<String> specRoleIds);

    /*****
     * 查询用户关联的案件审批角色信息
     * @param userId 用户Id
     * @param specRoleIds 领导角色Id集合
     * @return
     */
    List<SysRole> queryCaseApproveRoleRelEntityInfoByUserIdAndRoleIds(String userId, List<String> specRoleIds);

    /******
     * 获取用户特定的角色信息
     * @param subSysId 子系统Id
     * @param curUser 当前登录用户
     * @return
     */
    SysUser getUserSpecRoleInfo(String subSysId, SysUser curUser);

    /*******
     * 获取用户特殊角色信息
     * @param userId
     * @return
     */
    Map<String, Object> getUserLeaderRoleInfoByUserId(String userId);

    /*******
     * 获取用户特殊角色信息
     * @param userId
     * @return
     */
    Map<String, Object> getUserCaseApproveRoleInfoByUserId(String userId);

    /*****
     * 获取用户拥有特殊角色列表信息
     * @param entity 角色实体类信息
     * @param userId 用户信息
     * @param curUser 当前登录用户
     * @param isAdmin 是否管理员
     * @return
     */
    List<SysRole> userOwnXtbaCaseApproveRoleList(SysRole entity, String userId, SysUser curUser, boolean isAdmin);

    /*****
     * 获取用户未拥有特殊角色列表信息
     * @param entity 角色实体类信息
     * @param userId 用户信息
     * @param curUser 当前登录用户
     * @param isAdmin 是否管理员
     * @return
     */
    List<SysRole> userUnOwnXtbaCaseApproveRoleList(SysRole entity, String userId, SysUser curUser, boolean isAdmin);

    /*****
     * 定时解除户特殊角色关联关系
     */
    void taskRelieveSpecUserRoleRel();
}
