package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysDzqztp;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUserDzqz;

import java.util.List;

/****
 * @className SysUserDzqzService
 * @author chris
 * @description 用户电子签章服务层接口
 * @version 1.0
 * @date 2020-06-17 22:02
 */
public interface SysUserDzqzService {


    /*****
     * 未授权使用签章的用户的分页信息
     * @param page 分页信息
     * @param entity 用户实体类
     * @param signId 签章Id
     * @param curUserOrgId 当前组织机构Id
     * @param isAdmin 是否管理员
     * @return
     */
    Page<SysUser> userUnAuthSignPage(Page<SysUser> page, SysUser entity, String signId, String curUserOrgId, boolean isAdmin);

    /*****
     * 已授权使用签章的用户的分页信息
     * @param page 分页信息
     * @param entity 用户实体类
     * @param signId 签章Id
     * @param curUserOrgId 当前组织机构Id
     * @param isAdmin 是否管理员
     * @return
     */
    Page<SysUser> userGrantedSignPage(Page<SysUser> page, SysUser entity, String signId, String curUserOrgId, boolean isAdmin);

    /*****
     * 用户可使用签章分页信息
     * @param page 分页信息
     * @param entity 电子签章实体类
     * @param userId 用户Id
     * @param curUserOrgId 当前组织机构Id
     * @return
     */
    Page<SysDzqztp> userUsableSignPage(Page<SysDzqztp> page, SysDzqztp entity, String userId, String curUserOrgId);

    /******
     * 保存用户电子签章授权信息
     * @param userId 被授权用户主键Id
     * @param signId 电子签章主键Id
     * @param user 当前登录用户
     * @param isAdmin 是否管理员
     */
    void saveUserAuthSign(String userId, String signId, SysUser user, boolean isAdmin);

    /******
     * 解除用户电子签章授权信息
     * @param userId 当前授权用户信息Id
     * @param signId 电子签章主键Id
     * @param user 当前登录用户
     * @param isAdmin 是否管理员
     */
    void relieveUserAuthSign(String userId, String signId, SysUser user, boolean isAdmin);

    /********
     * 获取用户电子签章授权信息总数
     * @param dzqzId 电子签章Id
     * @return
     */
    Integer getUserDzqzRelTotalCountByDzqzId(String dzqzId);

    /******
     * 获取用户电子签章关联关系
     * @param userId 当前用户信息Id
     * @param dzqzId 电子签章Id
     * @return
     */
    SysUserDzqz getEntityInfoByUserIdAndDzqzId(String userId, String dzqzId);

    /******
     * 获取电子签章关联的用户
     * @param dzqzId 电子签章Id
     * @return
     */
    List<SysUserDzqz> getUserDzqzRelInfoByDzqzId(String dzqzId);

    /******
     * 清理旧数据信息
     * @param dzqzId 电子签章Id
     * @param user 当前登录用户
     */
    void clearOldEntityInfoByDzqzId(String dzqzId, SysUser user);

    /*******
     * 同步用户电子签章关联关系
     * @param userId 用户Id
     * @param dzqzId 电子签章Id
     * @param user 当前登录用户
     * @param isAdmin 是否管理员
     */
    void syncUserDzqzRelInfoByUserIdAndDzqzId(String userId, String dzqzId, SysUser user, boolean isAdmin);

    /******
     * 删除用户和电子签章关联关系
     * @param userId 用户Id
     * @param user 当前登录用户
     */
    void deleteAllUserDzqzRelByUserId(String userId, SysUser user);
}
