package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysSuggest;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className SysSuggestService
 * @author chris
 * @description 问题反馈服务层接口
 * @version 1.0
 * @date 2020-07-08 21:01
 */
public interface SysSuggestService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<SysSuggest> page(Page<SysSuggest> page, SysSuggest entity, String curUserOrgId);

    /*****
     * 保存问题反馈数据
     * @param entity 实体类
     * @param isCreate 是否创建
     * @param isAdmin 是否管理员
     * @param user 当前登录用户
     */
    void saveOrUpdate(SysSuggest entity, boolean isCreate, boolean isAdmin, SysUser user);

    /*****
     * 获取问题反馈信息
     * @param id 主键ID
     * @return
     */
    SysSuggest getEntityInfoById(String id);

    /*****
     * 删除问题反馈信息
     * @param ids 主键Id集合
     * @param user 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 校验状态
     * @param id 主键Id
     * @param optType 操作类型:1-修改,2-回复,3-追问,4-确认,5-删除
     * @return
     */
    boolean verifyStatusByIdAndType(String id, String optType);

    /*****
     * 修改问题反馈信息状态
     * @param id 主键Id
     * @param state 问题反馈信息状态
     */
    void updateEntityInfoStatus(String id, String state);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键集合
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<SysSuggest> export(SysSuggest entity, String ids, String curUserOrgId);
}
