package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysSuggestHis;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className SysSuggestHisService
 * @author chris
 * @description 问题反馈历史记录服务层接口
 * @version 1.0
 * @date 2020-07-08 21:01
 */
public interface SysSuggestHisService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<SysSuggestHis> page(Page<SysSuggestHis> page, SysSuggestHis entity);

    /*****
     * dataList查询
     * @param entity 实体类
     * @return
     */
    List<SysSuggestHis> dataList(SysSuggestHis entity);

    /******
     * 保存数据
     * @param entity
     * @param user
     */
    void saveOrUpdate(SysSuggestHis entity, SysUser user);

    /*****
     * 获取问题反馈历史信息明细
     * @param id 主键ID
     * @return
     */
    SysSuggestHis getEntityInfoById(String id);

    /******
     * 逻辑删除实体类信息
     * @param headId 表头Id
     * @param user 前登录用户
     */
    void deleteLogicEntityInfoByHeadId(String headId, SysUser user);
}
