package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysSubSystem;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className SysSubSystemService
 * @author chris
 * @description 子系统服务层接口接口
 * @version 1.0
 * @date 2019-12-24 11:12
 */
public interface SysSubSystemService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<SysSubSystem> page(Page<SysSubSystem> page, SysSubSystem entity);

    /*****
     * 保存子系统数据
     * @param entity 实体类
     * @param isCreate 是否创建
     * @param user 当前登录用户
     */
    void saveOrUpdate(SysSubSystem entity, boolean isCreate, SysUser user);

    /*****
     * 获取子系统信息
     * @param id 主键ID
     * @return
     */
    SysSubSystem getEntityInfoById(String id);

    /*****
     * 删除子系统信息
     * @param ids 主键Id集合
     * @param user 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 修改子系统状态
     * @param ids 主键Id集合
     * @param user 当前登录用户
     */
    void modifyStatusDataByIds(String ids, SysUser user);

    /*****
     * 查询子系统下拉框的键值对
     * @param filter 关键字过滤
     * @param subSysId 所属子系统Id
     * @return
     */
    List<ComboboxVo> queryEntityInfoCombobox(String filter, String subSysId);

    /*****
     * 查询子系统下拉框的键值对
     * @param filter 关键字过滤
     * @param subSysId 所属子系统Id
     * @return
     */
    List<ComboboxVo> queryEntityInfoCodeCombobox(String filter, String subSysId);

    /*****
     * 获取子系统的下一个序号
     * @return
     */
    Integer getSubSysNextOrderNo();

    /******
     * 设置子系统负责人相关信息
     * @param entity 实体类
     * @param user 当前登录用户
     */
    void setSubSysChargeInfo(SysSubSystem entity, SysUser user);

    /******
     * 获取用户拥有的子系统权限
     * @param userId
     * @return
     */
    List<SysSubSystem> getEntityInfoByUserId(String userId);
}
