package com.kdgcsoft.jt.xzzf.dubbo.system.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysSms;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @className SysSmsService
 * @author chris
 * @description 短信息服务层接口
 * @version 1.0
 * @date 2021-12-24 20:10
 */
public interface SysSmsService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<SysSms> pageData(Page<SysSms> page, SysSms entity);

    /*****
     * 列表查询
     * @param entity 实体类
     * @return
     */
    List<SysSms> listData(SysSms entity);

    /********
     * 获取短信息详细信息
     * @param id
     * @return
     */
    SysSms getEntityInfoById(String id);

    /*****
     * 保存短信数据
     * @param entity 实体类
     * @param isCreate 是否创建
     * @param user 创建人
     */
    void saveOrUpdate(SysSms entity, boolean isCreate, SysUser user);

    /*******
     * 发送短信
     * @param smsCode 接收人号码
     * @param smsMsg 短信内容
     */
    void sendMsg(String smsCode, String smsMsg);

    /*******
     * 发送短信
     * @param smsCode 接收人号码
     * @param smsMsg 短信内容
     * @param user 当前操作用户
     */
    void sendMsg(String smsCode, String smsMsg, SysUser user);

    /*******
     * 发送短信
     * @param entity 实体类
     * @param user 当前操作用户
     */
    void sendMsg(SysSms entity, SysUser user);

    /*******
     * 发送短信
     * @param entity 实体类
     */
    void sendMsg(SysSms entity);
}
